"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BlogPostDetectionEngineeringCallout = BlogPostDetectionEngineeringCallout;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _avc_banner_background = _interopRequireDefault(require("@kbn/avc-banner/src/avc_banner_background.svg"));
var _eui = require("@elastic/eui");
var _use_callout_storage = require("../../../../common/components/callouts/use_callout_storage");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BLOG_POST_URL = 'https://www.elastic.co/blog/elastic-security-detection-engineering';
const calloutMessage = {
  type: 'success',
  id: 'blog-post-elastic-security-detection-engineering',
  title: i18n.NEW_FEATURES_BLOG_POST_CALLOUT_TITLE,
  description: /*#__PURE__*/_react.default.createElement(Description, null)
};
function BlogPostDetectionEngineeringCallout() {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    isVisible,
    dismiss
  } = (0, _use_callout_storage.useCallOutStorage)([calloutMessage], 'detections');
  const calloutStyles = (0, _css.css)({
    paddingLeft: `${euiTheme.size.xl}`,
    backgroundImage: `url(${_avc_banner_background.default})`,
    backgroundRepeat: 'no-repeat',
    backgroundPositionX: 'right',
    backgroundPositionY: 'bottom'
  });
  const handleDismiss = (0, _react.useCallback)(() => {
    dismiss(calloutMessage);
  }, [dismiss]);
  if (!isVisible(calloutMessage)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: calloutMessage.title,
    color: calloutMessage.type,
    iconType: "cheer",
    onDismiss: handleDismiss,
    className: calloutStyles
  }, calloutMessage.description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
}
function Description() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.NEW_FEATURES_BLOG_POST_CALLOUT_DESCRIPTION, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    color: "success",
    href: BLOG_POST_URL,
    target: "_blank"
  }, i18n.NEW_FEATURES_BLOG_POST_CALLOUT_BUTTON_LABEL));
}