"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpyRouteComponent = exports.SpyRoute = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
var _use_route_spy = require("./use_route_spy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SpyRouteComponent = exports.SpyRouteComponent = /*#__PURE__*/(0, _react.memo)(({
  location: {
    pathname,
    search
  },
  history,
  match: {
    params: {
      detailName,
      tabName,
      flowTarget
    }
  },
  pageName,
  state
}) => {
  const [isInitializing, setIsInitializing] = (0, _react.useState)(true);
  const [route, dispatch] = (0, _use_route_spy.useRouteSpy)();
  (0, _react.useEffect)(() => {
    if (isInitializing && search !== '') {
      dispatch({
        type: 'updateSearch',
        search
      });
      setIsInitializing(false);
    } else if (search !== '' && search !== route.search) {
      dispatch({
        type: 'updateSearch',
        search
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [search]);
  (0, _react.useEffect)(() => {
    if (!pageName || route.pathName === pathname && (0, _fastDeepEqual.default)(state, route.state)) {
      return;
    }
    const newRouteState = {
      detailName,
      flowTarget,
      history,
      pageName,
      pathName: pathname,
      search,
      state,
      tabName
    };
    if (isInitializing && detailName == null) {
      dispatch({
        type: 'updateRouteWithOutSearch',
        route: (0, _lodash.omit)(newRouteState, 'search')
      });
      setIsInitializing(false);
      return;
    }
    dispatch({
      type: 'updateRoute',
      route: newRouteState
    });

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [pathname, search, pageName, detailName, tabName, flowTarget, state]);
  return null;
});
SpyRouteComponent.displayName = 'SpyRouteComponent';
const SpyRoute = exports.SpyRoute = (0, _reactRouterDom.withRouter)(SpyRouteComponent);