"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInitTimelineFromUrlParam = void 0;
var _react = require("react");
var _rison = require("@kbn/rison");
var _reactRedux = require("react-redux");
var _types = require("../../../../common/types");
var _global_query_string = require("../../utils/global_query_string");
var _helpers = require("../../../timelines/components/open_timeline/helpers");
var _selectors = require("../../../timelines/store/selectors");
var _use_url_state = require("../use_url_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInitTimelineFromUrlParam = () => {
  const queryTimelineById = (0, _helpers.useQueryTimelineById)();
  const activeTimeline = (0, _reactRedux.useSelector)(state => (0, _selectors.selectTimelineById)(state, _types.TimelineId.active));
  const onInitialize = (0, _react.useCallback)(initialState => {
    if (initialState != null) {
      queryTimelineById({
        activeTimelineTab: initialState.activeTab,
        duplicate: false,
        graphEventId: initialState.graphEventId,
        timelineId: initialState.id,
        openTimeline: initialState.isOpen,
        savedSearchId: initialState.savedSearchId,
        query: initialState.query
      });
    }
  }, [queryTimelineById]);
  (0, _react.useEffect)(() => {
    const listener = () => {
      const timelineState = new URLSearchParams(window.location.search).get(_use_url_state.URL_PARAM_KEY.timeline);
      if (!timelineState) {
        return;
      }
      const parsedState = (0, _rison.safeDecode)(timelineState);

      // Make sure we only re-initialize the timeline if there are significant changes to the active timeline.
      // Without this check, we could potentially overwrite the timeline.
      if (!hasTimelineStateChanged(activeTimeline, parsedState)) {
        onInitialize(parsedState);
      }
    };

    // This is needed to initialize the timeline from the URL when the user clicks the back / forward buttons
    window.addEventListener('popstate', listener);
    return () => window.removeEventListener('popstate', listener);
  }, [onInitialize, activeTimeline]);
  (0, _global_query_string.useInitializeUrlParam)(_use_url_state.URL_PARAM_KEY.timeline, onInitialize);
};
exports.useInitTimelineFromUrlParam = useInitTimelineFromUrlParam;
function hasTimelineStateChanged(activeTimeline, newState) {
  return activeTimeline && newState && (activeTimeline.id !== newState.id || activeTimeline.savedSearchId !== newState.savedSearchId || activeTimeline.graphEventId !== newState.graphEventId);
}