"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _types = require("../app/types");
var _kibana = require("../common/lib/kibana");
var _spy_routes = require("../common/utils/route/spy_routes");
var _filters_global = require("../common/components/filters_global");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _security_route_page_wrapper = require("../common/components/security_route_page_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This exists only for the type signature cast
const CloudPostureSpyRoute = ({
  pageName,
  ...rest
}) => /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, (0, _extends2.default)({
  pageName: pageName
}, rest));
const cspSecuritySolutionContext = {
  getFiltersGlobalComponent: () => _filters_global.FiltersGlobal,
  getSpyRouteComponent: () => CloudPostureSpyRoute
};
const CloudSecurityPosture = () => {
  const {
    cloudSecurityPosture
  } = (0, _kibana.useKibana)().services;
  const CloudSecurityPostureRouter = cloudSecurityPosture.getCloudSecurityPostureRouter();
  return /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(CloudSecurityPostureRouter, {
    securitySolutionContext: cspSecuritySolutionContext
  }));
};
CloudSecurityPosture.displayName = 'CloudSecurityPosture';
const routes = exports.routes = [{
  path: _cloudSecurityPostureCommon.CLOUD_SECURITY_POSTURE_BASE_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(CloudSecurityPosture, _types.SecurityPageName.cloudSecurityPostureDashboard, {
    omitSpyRoute: true
  })
}];