"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseProvider = void 0;
var _react = _interopRequireDefault(require("react"));
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CaseProvider = ({
  children
}) => {
  const {
    cases
  } = (0, _kibana.useKibana)().services;
  const CasesContext = cases.ui.getCasesContext();
  const userCasesPermissions = cases.helpers.canUseCases([_constants.APP_ID]);
  return /*#__PURE__*/_react.default.createElement(CasesContext, {
    owner: [_constants.APP_ID],
    permissions: userCasesPermissions
  }, children);
};
exports.CaseProvider = CaseProvider;