"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATED_BY = exports.UNKNOWN_TEXT = exports.STATUS_DATE = exports.STATUS_AT = exports.STATUS = exports.SCHEDULE_UPDATE_TITLE = exports.SCHEDULE_DETAILS_TITLE = exports.CREATED_BY = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SCHEDULE_DETAILS_TITLE = scheduleName => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.schedule.detailsFlyout.header.title', {
  defaultMessage: '{scheduleName}',
  values: {
    scheduleName
  }
});
exports.SCHEDULE_DETAILS_TITLE = SCHEDULE_DETAILS_TITLE;
const SCHEDULE_UPDATE_TITLE = scheduleName => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.schedule.detailsFlyout.header.updateScheduleTitle', {
  defaultMessage: 'Edit {scheduleName}',
  values: {
    scheduleName
  }
});
exports.SCHEDULE_UPDATE_TITLE = SCHEDULE_UPDATE_TITLE;
const CREATED_BY = exports.CREATED_BY = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.schedule.detailsFlyout.header.createdByDescription', {
  defaultMessage: 'Created by'
});
const UPDATED_BY = exports.UPDATED_BY = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.schedule.detailsFlyout.header.updatedByDescription', {
  defaultMessage: 'Updated by'
});
const STATUS = exports.STATUS = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.schedule.detailsFlyout.header.statusDescription', {
  defaultMessage: 'Last run'
});
const STATUS_AT = exports.STATUS_AT = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.schedule.detailsFlyout.header.statusAtDescription', {
  defaultMessage: 'at'
});
const STATUS_DATE = exports.STATUS_DATE = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.schedule.detailsFlyout.header.statusDateDescription', {
  defaultMessage: 'Status date'
});
const UNKNOWN_TEXT = exports.UNKNOWN_TEXT = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.schedule.detailsFlyout.header.unknownText', {
  defaultMessage: 'Unknown'
});