"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tactic = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _axis_tick = require("../axis_tick");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INNER_CIRCLE_LEFT_JUSTIFY_X_OFFSET = 0; // px
const OUTER_CIRCLE_LEFT_JUSTIFY_X_OFFSET = -4; // px

const TacticComponent = ({
  detected,
  tactic
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const WIDTH = 144; // px
  const TICK_COUNT = 12;
  const ticks = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    "data-tests-subj": "ticks",
    gutterSize: "none",
    responsive: false,
    wrap: false
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
            overflow: hidden;
            width: ${WIDTH}px;
          `
  }), Array.from({
    length: TICK_COUNT
  }).map((_, i) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    key: i,
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_axis_tick.AxisTick, null)))), []);
  const color = detected ? euiTheme.colors.danger : euiTheme.colors.subduedText;
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
        width: ${WIDTH}px;
      `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "tactic",
    direction: "column",
    gutterSize: "none",
    responsive: false,
    wrap: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
            position: relative;
          `,
    "data-test-subj": "tics",
    grow: false
  }, /*#__PURE__*/_react2.default.createElement("div", {
    // eslint-disable-next-line @kbn/css/no_css_color -- euiTheme.colors.danger is a string
    css: (0, _react.css)`
              background: transparent;
              border: 2px solid ${color};
              border-radius: 50%;
              height: 8px;
              position: absolute;
              transform: translate(${INNER_CIRCLE_LEFT_JUSTIFY_X_OFFSET}px, -2px);
              width: 8px;
            `,
    "data-test-subj": "innerCircle"
  }), /*#__PURE__*/_react2.default.createElement("div", {
    // eslint-disable-next-line @kbn/css/no_css_color -- euiTheme.colors.danger is a string
    css: (0, _react.css)`
              background: transparent;
              border: 2px solid ${color};
              border-radius: 50%;
              height: 16px;
              opacity: ${detected ? 25 : 0}%;
              position: absolute;
              transform: translate(${OUTER_CIRCLE_LEFT_JUSTIFY_X_OFFSET}px, -6px);
              width: 16px;
            `,
    "data-test-subj": "outerCircle"
  }), /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, ticks)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
            position: relative;
          `,
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
            position: relative;
          `,
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: color,
    "data-test-subj": "tacticText",
    size: "xs"
  }, tactic))));
};
TacticComponent.displayName = 'Tactic';
const Tactic = exports.Tactic = /*#__PURE__*/_react2.default.memo(TacticComponent);