"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _fp = require("lodash/fp");
var _react2 = _interopRequireWildcard(require("react"));
var _elastic_llm = require("@kbn/elastic-assistant/impl/tour/elastic_llm");
var _const = require("@kbn/elastic-assistant/impl/tour/const");
var _actions = require("./actions");
var _use_space_id = require("../../../common/hooks/use_space_id");
var _constants = require("../settings_flyout/constants");
var _status_bell = require("./status_bell");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_kibana_feature_flags = require("../use_kibana_feature_flags");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HeaderComponent = ({
  connectorId,
  connectorsAreConfigured,
  isLoading,
  isDisabledActions,
  onGenerate,
  onConnectorIdSelected,
  onCancel,
  openFlyout,
  stats,
  showFlyout
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isDisabled = connectorId == null;
  const [didCancel, setDidCancel] = (0, _react2.useState)(false);
  const {
    inferenceEnabled
  } = (0, _elasticAssistant.useAssistantContext)();
  const {
    attackDiscoveryAlertsEnabled
  } = (0, _use_kibana_feature_flags.useKibanaFeatureFlags)();
  const spaceId = (0, _use_space_id.useSpaceId)();
  const [isEISCostTourDisabled, setIsEISCostTourDisabled] = (0, _react2.useState)(attackDiscoveryAlertsEnabled || !connectorsAreConfigured || !spaceId || !inferenceEnabled || showFlyout);
  (0, _react2.useEffect)(() => {
    if (attackDiscoveryAlertsEnabled || !connectorsAreConfigured || !spaceId || !inferenceEnabled || showFlyout) {
      setIsEISCostTourDisabled(true);
    } else {
      setIsEISCostTourDisabled(false);
    }
  }, [attackDiscoveryAlertsEnabled, connectorsAreConfigured, inferenceEnabled, isEISCostTourDisabled, showFlyout, spaceId]);
  const handleCancel = (0, _react2.useCallback)(() => {
    setDidCancel(true);
    onCancel();
  }, [onCancel]);
  (0, _react2.useEffect)(() => {
    if (isLoading === false) setDidCancel(false);
  }, [isLoading]);
  const buttonProps = (0, _react2.useMemo)(() => isLoading && !attackDiscoveryAlertsEnabled ? {
    dataTestSubj: 'cancel',
    color: 'danger',
    fill: attackDiscoveryAlertsEnabled,
    onClick: handleCancel,
    text: i18n.CANCEL
  } : {
    color: 'primary',
    dataTestSubj: 'generate',
    fill: attackDiscoveryAlertsEnabled,
    onClick: () => onGenerate(),
    text: i18n.GENERATE
  }, [attackDiscoveryAlertsEnabled, handleCancel, isLoading, onGenerate]);
  const openLegacySettingsFlyout = (0, _react2.useCallback)(() => openFlyout(_constants.SETTINGS_TAB_ID), [openFlyout]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: (0, _react.css)`
        margin-top: ${attackDiscoveryAlertsEnabled ? 0 : euiTheme.size.m};
      `,
    "data-test-subj": "header",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: attackDiscoveryAlertsEnabled ? 'rowReverse' : 'row',
    gutterSize: "none",
    responsive: false,
    wrap: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, !attackDiscoveryAlertsEnabled && connectorsAreConfigured && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    wrap: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "statusBell",
    grow: false,
    css: (0, _react.css)`
                    margin-left: ${euiTheme.size.s};
                    margin-right: ${euiTheme.size.s};
                  `
  }, /*#__PURE__*/_react2.default.createElement(_status_bell.StatusBell, {
    stats: stats
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, spaceId && /*#__PURE__*/_react2.default.createElement(_elasticAssistant.AssistantSpaceIdProvider, {
    spaceId: spaceId
  }, /*#__PURE__*/_react2.default.createElement(_elastic_llm.ElasticLLMCostAwarenessTour, {
    isDisabled: isEISCostTourDisabled,
    selectedConnectorId: connectorId,
    zIndex: 999 // Should lower than the flyout
    ,
    storageKey: _const.NEW_FEATURES_TOUR_STORAGE_KEYS.ELASTIC_LLM_USAGE_ATTACK_DISCOVERY
  }, /*#__PURE__*/_react2.default.createElement(_elasticAssistant.ConnectorSelectorInline, {
    onConnectorSelected: _fp.noop,
    onConnectorIdSelected: onConnectorIdSelected,
    selectedConnectorId: connectorId,
    stats: stats
  })))))))), attackDiscoveryAlertsEnabled ?
  /*#__PURE__*/
  /* New Actions component when feature flag is enabled */
  _react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_actions.Actions, {
    isLoading: isLoading,
    onGenerate: onGenerate,
    openFlyout: openFlyout,
    isDisabled: isDisabled
  })) :
  /*#__PURE__*/
  /* Legacy settings and generate buttons when feature flag is disabled */
  _react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
              margin-right: ${euiTheme.size.m};
            `,
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: i18n.SETTINGS,
    "data-test-subj": "openAlertSelectionToolTip"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.SETTINGS,
    color: "text",
    "data-test-subj": "openAlertSelection",
    iconType: "gear",
    onClick: openLegacySettingsFlyout
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: connectorId == null ? i18n.SELECT_A_CONNECTOR : null,
    "data-test-subj": "generateTooltip"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    color: buttonProps.color,
    "data-test-subj": buttonProps.dataTestSubj,
    disabled: isDisabled || didCancel || isDisabledActions,
    fill: buttonProps.fill,
    onClick: buttonProps.onClick,
    size: attackDiscoveryAlertsEnabled ? 'm' : 's'
  }, buttonProps.text)))));
};
HeaderComponent.displayName = 'Header';
const Header = exports.Header = /*#__PURE__*/_react2.default.memo(HeaderComponent);