"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _create_role_mapping_button = require("../create_role_mapping_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyPrompt = ({
  history,
  readOnly = false
}) => /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
  iconType: "managementApp",
  title: /*#__PURE__*/_react.default.createElement("h1", null, readOnly ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.roleMappings.readOnlyEmptyPromptTitle",
    defaultMessage: "There are no role mappings to view"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.roleMappings.emptyPromptTitle",
    defaultMessage: "Create your first role mapping"
  })),
  body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.roleMappings.emptyPromptDescription",
    defaultMessage: "Role mappings control which roles are assigned to your users."
  })),
  actions: readOnly ? null : /*#__PURE__*/_react.default.createElement(_create_role_mapping_button.CreateRoleMappingButton, {
    history: history
  }),
  "data-test-subj": "roleMappingsEmptyPrompt"
});
exports.EmptyPrompt = EmptyPrompt;