"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SynonymRuleFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _synonyms_utils = require("../../utils/synonyms_utils");
var _use_put_synonyms_rule = require("../../hooks/use_put_synonyms_rule");
var _use_flyout_state = require("./use_flyout_state");
var _constants = require("../../analytics/constants");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SynonymRuleFlyout = ({
  flyoutMode,
  synonymsRule,
  onClose,
  renderExplicit = false,
  synonymsSetId
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [backendError, setBackendError] = _react.default.useState(null);
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    mutate: putSynonymsRule
  } = (0, _use_put_synonyms_rule.usePutSynonymsRule)(() => onClose(), error => {
    setBackendError(error);
  });
  const {
    canSave,
    currentSortDirection,
    fromTermErrors,
    fromTerms,
    hasChanges,
    isExplicit,
    isFromTermsInvalid,
    isMapToTermsInvalid,
    mapToTermErrors,
    mapToTerms,
    clearFromTerms,
    onCreateOption,
    onMapToChange,
    onSearchChange,
    onSortTerms,
    removeTermFromOptions,
    resetChanges
  } = (0, _use_flyout_state.useSynonymRuleFlyoutState)({
    synonymRule: synonymsRule,
    flyoutMode,
    renderExplicit
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    size: '33%',
    outsideClickCloses: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "searchSynonymsSynonymRuleFlyoutRuleIdText"
  }, /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetRuleFlyout.title.ruleId', {
    defaultMessage: 'Rule ID: {ruleId}',
    values: {
      ruleId: synonymsRule.id
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    css: (0, _react2.css)`
          .euiFlyoutBody__overflowContent {
            height: 100%;
          }
        `,
    banner: backendError && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      "data-test-subj": "searchSynonymsSynonymsRuleFlyoutErrorBanner",
      color: "danger",
      title: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetRuleFlyout.errorCallout.title', {
        defaultMessage: 'An error occured while saving your changes'
      })
    }, backendError)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    direction: "column",
    gutterSize: "none",
    css: (0, _react2.css)`
            height: 100%;
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetRuleFlyout.synonyms', {
      defaultMessage: 'Add terms to match against'
    }),
    isInvalid: isFromTermsInvalid,
    error: fromTermErrors || null
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    "data-test-subj": "searchSynonymsSynonymsRuleFlyoutFromTermsInput",
    isInvalid: isFromTermsInvalid,
    noSuggestions: true,
    placeholder: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetRuleFlyout.synonyms.inputPlaceholder', {
      defaultMessage: 'Add terms to match against'
    }),
    onCreateOption: onCreateOption,
    delimiter: ",",
    onSearchChange: onSearchChange
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    "data-test-subj": "searchSynonymsSynonymsRuleFlyoutTermCountLabel"
  }, /*#__PURE__*/_react.default.createElement("p", null, fromTerms.length <= 1 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchSynonyms.synonymsSetRuleFlyout.synonymsCount.single",
    defaultMessage: "{count} term",
    values: {
      count: fromTerms.length
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchSynonyms.synonymsSetRuleFlyout.synonymsCount.multiple",
    defaultMessage: "{count} terms",
    values: {
      count: fromTerms.length
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "searchSynonymsSynonymsRuleFlyoutSortAZButton",
    size: "s",
    color: "text",
    onClick: () => onSortTerms(),
    iconType: currentSortDirection === 'ascending' ? 'sortUp' : 'sortDown'
  }, currentSortDirection === 'ascending' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchSynonyms.synonymsSetRuleFlyout.sortAZ",
    defaultMessage: "Sort A-Z"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchSynonyms.synonymsSetRuleFlyout.sortZA",
    defaultMessage: "Sort Z-A"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "searchSynonymsSynonymsRuleFlyoutRemoveAllButton",
    color: "danger",
    size: "s",
    onClick: clearFromTerms
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchSynonyms.synonymsSetRuleFlyout.clearAll",
    defaultMessage: "Remove all"
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
              max-height: ${isExplicit ? '75%' : '90%'};
            `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    tabIndex: 0,
    className: "eui-yScrollWithShadows",
    css: (0, _react2.css)`
                margin: ${euiTheme.size.xs};
              `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), fromTerms.map((opt, index) => /*#__PURE__*/_react.default.createElement("span", {
    key: index + '-' + opt.label.trim()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "searchSynonymsSynonymsRuleFlyoutFromTermBadge",
    color: "hollow",
    iconSide: "left",
    iconType: "cross",
    iconOnClick: () => {
      removeTermFromOptions(opt);
    },
    iconOnClickAriaLabel: "remove"
  }, "\xA0", opt.label))), fromTerms.length === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    textAlign: "center",
    size: "s",
    "data-test-subj": "searchSynonymsSynonymsRuleFlyoutNoTermsText"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchSynonyms.synonymsSetRuleFlyout.noTerms",
    defaultMessage: "No terms found."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }))), isExplicit && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetRuleFlyout.synonymsTo', {
      defaultMessage: 'Map to this term'
    }),
    isInvalid: mapToTerms !== '' && isMapToTermsInvalid,
    error: mapToTermErrors || null
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    prepend: '=>',
    "data-test-subj": "searchSynonymsSynonymsRuleFlyoutMapToTermsInput",
    fullWidth: true,
    value: mapToTerms,
    isInvalid: mapToTerms !== '' && isMapToTermsInvalid,
    onChange: e => {
      onMapToChange(e.target.value);
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, hasChanges && /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "primary",
    "data-test-subj": "searchSynonymsSynonymsRuleFlyoutHasChangesBadge"
  }, _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetRuleFlyout.unsavedChanges', {
    defaultMessage: 'Synonym rule has unsaved changes'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "searchSynonymsSynonymsRuleFlyoutResetChangesButton",
    iconType: "refresh",
    disabled: !hasChanges,
    onClick: resetChanges
  }, _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetRuleFlyout.reset', {
    defaultMessage: 'Reset changes'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "searchSynonymsSynonymsRuleFlyoutSaveButton",
    fill: true,
    disabled: !canSave,
    onClick: () => {
      if (!synonymsRule.id) {
        return;
      }
      if (flyoutMode === 'create') {
        usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.new_rule_created);
      } else {
        usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.rule_updated);
      }
      putSynonymsRule({
        synonymsSetId,
        ruleId: synonymsRule.id,
        synonyms: (0, _synonyms_utils.synonymsOptionToString)({
          fromTerms,
          toTerms: mapToTerms,
          isExplicit
        })
      });
    }
  }, _i18n.i18n.translate('xpack.searchSynonyms.synonymsSetRuleFlyout.save', {
    defaultMessage: 'Save'
  }))))))));
};
exports.SynonymRuleFlyout = SynonymRuleFlyout;