"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LOCAL_STORAGE_KEY = exports.FormProvider = void 0;
var _reactHookForm = require("react-hook-form");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _use_load_fields_by_indices = require("../hooks/use_load_fields_by_indices");
var _types = require("../types");
var _use_llms_models = require("../hooks/use_llms_models");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOCAL_STORAGE_KEY = exports.LOCAL_STORAGE_KEY = 'search_playground_session';
const DEFAULT_FORM_VALUES = {
  prompt: 'You are an assistant for question-answering tasks.',
  doc_size: 3,
  source_fields: {},
  indices: [],
  summarization_model: undefined
};
const getLocalSession = storage => {
  try {
    const localSessionJSON = storage.getItem(LOCAL_STORAGE_KEY);
    const sessionState = localSessionJSON ? JSON.parse(localSessionJSON) : {};
    return {
      ...DEFAULT_FORM_VALUES,
      ...sessionState
    };
  } catch (e) {
    return DEFAULT_FORM_VALUES;
  }
};
const setLocalSession = (formState, storage) => {
  // omit question and search_query from the session state
  const {
    question,
    search_query: searchQuery,
    ...state
  } = formState;
  storage.setItem(LOCAL_STORAGE_KEY, JSON.stringify(state));
};
const FormProvider = ({
  children,
  storage = localStorage
}) => {
  const models = (0, _use_llms_models.useLLMsModels)();
  const [searchParams] = (0, _reactRouterDomV5Compat.useSearchParams)();
  const index = (0, _react.useMemo)(() => searchParams.get('default-index'), [searchParams]);
  const sessionState = (0, _react.useMemo)(() => getLocalSession(storage), [storage]);
  const form = (0, _reactHookForm.useForm)({
    defaultValues: {
      ...sessionState,
      indices: index ? [index] : sessionState.indices,
      search_query: ''
    }
  });
  (0, _use_load_fields_by_indices.useLoadFieldsByIndices)({
    watch: form.watch,
    setValue: form.setValue,
    getValues: form.getValues
  });
  (0, _react.useEffect)(() => {
    const subscription = form.watch(values => setLocalSession(values, storage));
    return () => subscription.unsubscribe();
  }, [form, storage]);
  (0, _react.useEffect)(() => {
    if (models.length === 0) return; // don't continue if there are no models
    const defaultModel = models.find(model => !model.disabled);
    const currentModel = form.getValues(_types.ChatFormFields.summarizationModel);
    if (defaultModel && (!currentModel || !models.find(model => currentModel.id === model.id))) {
      form.setValue(_types.ChatFormFields.summarizationModel, defaultModel);
    }
  }, [form, models]);
  return /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, form, children);
};
exports.FormProvider = FormProvider;