"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSourceFields = exports.LANGCHAIN_PYTHON = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _prompt = require("../../../../common/prompt");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSourceFields = sourceFields => {
  const fields = Object.keys(sourceFields).reduce((acc, index) => {
    acc[index] = sourceFields[index][0];
    return acc;
  }, {});
  return JSON.stringify(fields, null, 4);
};
exports.getSourceFields = getSourceFields;
const LANGCHAIN_PYTHON = (formValues, clientDetails) => /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
  language: "py",
  isCopyable: true,
  overflowHeight: "100%"
}, `## Install the required packages
## pip install -qU elasticsearch langchain langchain-elasticsearch langchain-openai

from langchain_elasticsearch import ElasticsearchRetriever
from langchain_openai import ChatOpenAI
from langchain_core.runnables import RunnablePassthrough
from langchain_core.prompts import ChatPromptTemplate
from langchain_core.output_parsers import StrOutputParser
from langchain_core.prompts import format_document
from langchain.prompts.prompt import PromptTemplate
import os
${clientDetails}

def build_query(query):
    return ${(0, _utils.getESQuery)(formValues.elasticsearch_query)}

index_source_fields = ${getSourceFields(formValues.source_fields)}

retriever = ElasticsearchRetriever(
    index_name="${formValues.indices.join(',')}",
    body_func=build_query,
    content_field=index_source_fields,
    es_client=es_client
)

model = ChatOpenAI(openai_api_key=os.environ["OPENAI_API_KEY"], model_name="gpt-3.5-turbo")

ANSWER_PROMPT = ChatPromptTemplate.from_template(
    """${(0, _prompt.Prompt)(formValues.prompt, {
  context: true,
  citations: formValues.citations,
  type: 'openai'
})}"""
)

DEFAULT_DOCUMENT_PROMPT = PromptTemplate.from_template(template="{page_content}")

def _combine_documents(
    docs, document_prompt=DEFAULT_DOCUMENT_PROMPT, document_separator="\\n\\n"
):
    doc_strings = [format_document(doc, document_prompt) for doc in docs]
    return document_separator.join(doc_strings)

_context = {
    "context": retriever | _combine_documents,
    "question": RunnablePassthrough(),
}

chain = _context | ANSWER_PROMPT | model | StrOutputParser()
ans = chain.invoke("what is the nasa sales team?")
print("---- Answer ----")
print(ans)`);
exports.LANGCHAIN_PYTHON = LANGCHAIN_PYTHON;