"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryMode = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_source_indices_field = require("../../hooks/use_source_indices_field");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _types = require("../../types");
var _constants = require("../../analytics/constants");
var _doc_links = require("../../../common/doc_links");
var _create_query = require("../../utils/create_query");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isQueryFieldSelected = (queryFields, index, field) => {
  var _queryFields$index;
  return Boolean((_queryFields$index = queryFields[index]) === null || _queryFields$index === void 0 ? void 0 : _queryFields$index.includes(field));
};
const QueryMode = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    fields
  } = (0, _use_source_indices_field.useSourceIndicesFields)();
  const sourceFields = (0, _reactHookForm.useWatch)({
    name: _types.ChatFormFields.sourceFields
  });
  const {
    field: {
      onChange: queryFieldsOnChange,
      value: queryFields
    }
  } = (0, _reactHookForm.useController)({
    name: _types.ChatFormFields.queryFields
  });
  const {
    field: {
      onChange: elasticsearchQueryChange,
      value: elasticsearchQuery
    }
  } = (0, _reactHookForm.useController)({
    name: _types.ChatFormFields.elasticsearchQuery
  });
  const updateFields = (index, fieldName, checked) => {
    const currentIndexFields = checked ? [...queryFields[index], fieldName] : queryFields[index].filter(field => fieldName !== field);
    const updatedQueryFields = {
      ...queryFields,
      [index]: currentIndexFields
    };
    queryFieldsOnChange(updatedQueryFields);
    elasticsearchQueryChange((0, _create_query.createQuery)(updatedQueryFields, sourceFields, fields));
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.count(_constants.AnalyticsEvents.queryFieldsUpdated, currentIndexFields.length);
  };
  (0, _react.useEffect)(() => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.queryModeLoaded);
  }, [usageTracker]);
  const query = (0, _react.useMemo)(() => JSON.stringify(elasticsearchQuery, null, 2), [elasticsearchQuery]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6,
    className: "eui-yScroll",
    css: {
      padding: euiTheme.size.l,
      paddingRight: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    fontSize: "m",
    paddingSize: "none",
    lineNumbers: true,
    transparentBackground: true,
    "data-test-subj": "ViewElasticsearchQueryResult"
  }, query)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    className: "eui-yScroll",
    css: {
      padding: euiTheme.size.l,
      paddingLeft: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.flyout.table.title",
    defaultMessage: "Fields to search (per index)"
  }))), Object.entries(fields).map(([index, group], indexNum) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: index
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: false,
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: index,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, index)),
    initialIsOpen: true,
    "data-test-subj": `fieldsAccordion-${indexNum}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableCaption: "Query Model table",
    items: [...group.semantic_fields, ...group.elser_query_fields, ...group.dense_vector_query_fields, ...group.bm25_query_fields].map(field => ({
      name: typeof field === 'string' ? field : field.field,
      checked: isQueryFieldSelected(queryFields, index, typeof field === 'string' ? field : field.field)
    })),
    rowHeader: "name",
    columns: [{
      field: 'name',
      name: 'Field',
      'data-test-subj': 'fieldName'
    }, {
      field: 'checked',
      name: 'Enabled',
      align: 'right',
      render: (checked, field) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
          showLabel: false,
          label: field.name,
          checked: checked,
          onChange: e => updateFields(index, field.name, e.target.checked),
          compressed: true,
          "data-test-subj": `field-${field.name}-${checked}`
        });
      }
    }]
  }), group.skipped_fields > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    "data-test-subj": `skippedFields-${indexNum}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "eyeClosed"
  }), ` `, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.flyout.hiddenFields",
    defaultMessage: "{skippedFields} fields are hidden.",
    values: {
      skippedFields: group.skipped_fields
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.hiddenFields,
    target: "_blank",
    "data-test-subj": "hidden-fields-documentation-link"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.flyout.learnMoreLink",
    defaultMessage: "Learn more."
  }))))))))))));
};
exports.QueryMode = QueryMode;