"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchNotebooksView = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _reactQuery = require("@kbn/react-query");
var _search_notebooks = require("./search_notebooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchNotebooksView = ({
  core,
  queryClient,
  usageTracker,
  getNotebookList
}) => {
  _react.default.useEffect(() => {
    usageTracker.count('opened_notebooks_view');
  }, [usageTracker]);
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: core.theme
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...core,
      notebooks: {
        getNotebookList
      },
      usageTracker
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_search_notebooks.SearchNotebooks, null))));
};
exports.SearchNotebooksView = SearchNotebooksView;