"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUserPrivilegesQuery = void 0;
var _reactQuery = require("@kbn/react-query");
var _routes = require("../../../common/routes");
var _constants = require("../../constants");
var _use_kibana = require("../use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUserPrivilegesQuery = () => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)({
    queryKey: [_constants.QueryKeys.FetchUserStartPrivileges],
    queryFn: () => http.get(_routes.GET_USER_PRIVILEGES_ROUTE)
  });
};
exports.useUserPrivilegesQuery = useUserPrivilegesQuery;