"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DenseVectorSeverlessCodeExamples = exports.DefaultServerlessCodeExamples = void 0;
var _constants = require("./constants");
var _curl = require("./curl");
var _javascript = require("./javascript");
var _python = require("./python");
var _sense = require("./sense");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DefaultServerlessCodeExamples = exports.DefaultServerlessCodeExamples = {
  exampleType: 'search',
  installTitle: _constants.INSTALL_INSTRUCTIONS_TITLE,
  installDescription: _constants.INSTALL_INSTRUCTIONS_DESCRIPTION,
  createIndexTitle: _constants.CONNECT_CREATE_VECTOR_INDEX_CMD_TITLE,
  createIndexDescription: _constants.CONNECT_CREATE_VECTOR_INDEX_CMD_DESCRIPTION,
  sense: _sense.ConsoleCreateIndexExamples.default,
  curl: _curl.CurlCreateIndexExamples.default,
  python: _python.PythonServerlessCreateIndexExamples.default,
  javascript: _javascript.JavascriptServerlessCreateIndexExamples.default
};
const DenseVectorSeverlessCodeExamples = exports.DenseVectorSeverlessCodeExamples = {
  exampleType: 'vector',
  installTitle: _constants.INSTALL_INSTRUCTIONS_TITLE,
  installDescription: _constants.INSTALL_INSTRUCTIONS_DESCRIPTION,
  createIndexTitle: _constants.CONNECT_CREATE_VECTOR_INDEX_CMD_TITLE,
  createIndexDescription: _constants.CONNECT_CREATE_VECTOR_INDEX_CMD_DESCRIPTION,
  sense: _sense.ConsoleCreateIndexExamples.dense_vector,
  curl: _curl.CurlCreateIndexExamples.dense_vector,
  python: _python.PythonServerlessCreateIndexExamples.dense_vector,
  javascript: _javascript.JavascriptServerlessCreateIndexExamples.dense_vector
};