"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchConnectorsPlugin = void 0;
var _searchConnectors = require("@kbn/search-connectors");
var _connector_types = require("../common/lib/connector_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SearchConnectorsPlugin {
  setup(core, setupDeps) {
    const connectorTypes = (0, _connector_types.getConnectorTypes)(core.http.staticAssets);
    return {
      getConnectorTypes: () => connectorTypes
    };
  }
  start(core, services) {
    const {
      http
    } = core;
    _searchConnectors.docLinks.setDocLinks(core.docLinks.links);
    const connectorTypes = (0, _connector_types.getConnectorFullTypes)(http.staticAssets);
    return {
      getConnectorTypes: () => connectorTypes
    };
  }
  stop() {}
}
exports.SearchConnectorsPlugin = SearchConnectorsPlugin;