"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportSummary = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lib = require("../../../lib");
require("./import_summary.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DEFAULT_ICON = 'apps';
const unsupportedTypeErrorMessage = _i18n.i18n.translate('savedObjectsManagement.objectsTable.importSummary.unsupportedTypeError', {
  defaultMessage: 'Unsupported object type'
});
const getErrorMessage = ({
  error
}) => {
  if (error.type === 'unknown') {
    return error.message;
  } else if (error.type === 'unsupported_type') {
    return unsupportedTypeErrorMessage;
  }
};
const mapFailedImport = failure => {
  const {
    obj
  } = failure;
  const {
    type,
    id,
    meta
  } = obj;
  const title = meta.title || (0, _lib.getDefaultTitle)(obj);
  const icon = meta.icon || DEFAULT_ICON;
  const errorMessage = getErrorMessage(failure);
  return {
    type,
    id,
    title,
    icon,
    outcome: 'error',
    errorMessage
  };
};
const mapImportSuccess = obj => {
  const {
    type,
    id,
    meta,
    overwrite
  } = obj;
  const title = meta.title || (0, _lib.getDefaultTitle)(obj);
  const icon = meta.icon || DEFAULT_ICON;
  const outcome = overwrite ? 'overwritten' : 'created';
  return {
    type,
    id,
    title,
    icon,
    outcome
  };
};
const CountIndicators = ({
  importItems
}) => {
  if (!importItems.length) {
    return null;
  }
  const outcomeCounts = importItems.reduce((acc, {
    outcome
  }) => {
    var _acc$get;
    return acc.set(outcome, ((_acc$get = acc.get(outcome)) !== null && _acc$get !== void 0 ? _acc$get : 0) + 1);
  }, new Map());
  const createdCount = outcomeCounts.get('created');
  const overwrittenCount = outcomeCounts.get('overwritten');
  const errorCount = outcomeCounts.get('error');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, createdCount && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", {
    className: "savedObjectsManagementImportSummary__createdCount"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.importSummary.createdCountHeader",
    defaultMessage: "{createdCount} new",
    values: {
      createdCount
    }
  })))), overwrittenCount && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", {
    className: "savedObjectsManagementImportSummary__overwrittenCount"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.importSummary.overwrittenCountHeader",
    defaultMessage: "{overwrittenCount} overwritten",
    values: {
      overwrittenCount
    }
  })))), errorCount && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", {
    "data-test-subj": "importSavedObjectsErrorsCount",
    className: "savedObjectsManagementImportSummary__errorCount"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.importSummary.errorCountHeader",
    defaultMessage: "{errorCount} error",
    values: {
      errorCount
    }
  })))));
};
const StatusIndicator = ({
  item
}) => {
  const {
    outcome,
    errorMessage = 'Error'
  } = item;
  switch (outcome) {
    case 'created':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: 'checkInCircleFilled',
        color: 'success',
        content: _i18n.i18n.translate('savedObjectsManagement.importSummary.createdOutcomeLabel', {
          defaultMessage: 'Created'
        })
      });
    case 'overwritten':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: 'check',
        content: _i18n.i18n.translate('savedObjectsManagement.importSummary.overwrittenOutcomeLabel', {
          defaultMessage: 'Overwritten'
        })
      });
    case 'error':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: 'error',
        color: 'danger',
        content: _i18n.i18n.translate('savedObjectsManagement.importSummary.errorOutcomeLabel', {
          defaultMessage: '{errorMessage}',
          values: {
            errorMessage
          }
        })
      });
  }
};
const ImportWarnings = ({
  warnings,
  basePath
}) => {
  if (!warnings.length) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), warnings.map((warning, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: `warning-${index}`
  }, /*#__PURE__*/_react.default.createElement(ImportWarning, {
    warning: warning,
    basePath: basePath
  }), index < warnings.length - 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }))));
};
const ImportWarning = ({
  warning,
  basePath
}) => {
  const warningContent = (0, _react.useMemo)(() => {
    if (warning.type === 'action_required') {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "flexEnd",
        justifyContent: "flexEnd",
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        size: "s",
        color: "warning",
        href: basePath.prepend(warning.actionPath),
        target: "_blank"
      }, warning.buttonLabel || /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "savedObjectsManagement.importSummary.warnings.defaultButtonLabel",
        defaultMessage: "Go"
      }))));
    }
    return null;
  }, [warning, basePath]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "s",
    iconType: "warning",
    "data-test-subj": "importSavedObjectsWarning",
    title: warning.message
  }, warningContent);
};
const ImportSummary = ({
  failedImports,
  successfulImports,
  importWarnings,
  basePath,
  allowedTypes
}) => {
  const importItems = (0, _react.useMemo)(() => _lodash.default.sortBy([...failedImports.map(x => mapFailedImport(x)), ...successfulImports.map(x => mapImportSuccess(x))], ['type', 'title']), [successfulImports, failedImports]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": importItems.length ? 'importSavedObjectsSuccess' : 'importSavedObjectsSuccessNoneImported'
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.importSummary.headerLabel",
    defaultMessage: "{importCount, plural, one {1 object} other {# objects}} imported",
    values: {
      importCount: importItems.length
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(CountIndicators, {
    importItems: importItems
  }), /*#__PURE__*/_react.default.createElement(ImportWarnings, {
    warnings: importWarnings,
    basePath: basePath
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), importItems.map((item, index) => {
    const {
      type,
      title,
      icon
    } = item;
    const typeLabel = (0, _lib.getSavedObjectLabel)(type, allowedTypes);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      key: index,
      alignItems: "center",
      gutterSize: "s",
      className: "savedObjectsManagementImportSummary__row"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: typeLabel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "aria-label": typeLabel,
      type: icon,
      size: "s"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "savedObjectsManagementImportSummary__title"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", {
      className: "eui-textTruncate",
      title: title
    }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "eui-textRight"
    }, /*#__PURE__*/_react.default.createElement(StatusIndicator, {
      item: item
    }))));
  }));
};
exports.ImportSummary = ImportSummary;