"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.anomalyParamsSchema = exports.AnomalyDetectorType = void 0;
var _configSchema = require("@kbn/config-schema");
var _anomaly_severity = require("@kbn/ml-anomaly-utils/anomaly_severity");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let AnomalyDetectorType = exports.AnomalyDetectorType = /*#__PURE__*/function (AnomalyDetectorType) {
  AnomalyDetectorType["txLatency"] = "txLatency";
  AnomalyDetectorType["txThroughput"] = "txThroughput";
  AnomalyDetectorType["txFailureRate"] = "txFailureRate";
  return AnomalyDetectorType;
}({});
const detectorsSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(AnomalyDetectorType.txLatency), _configSchema.schema.literal(AnomalyDetectorType.txThroughput), _configSchema.schema.literal(AnomalyDetectorType.txFailureRate)]);
const anomalyParamsSchema = exports.anomalyParamsSchema = _configSchema.schema.object({
  serviceName: _configSchema.schema.maybe(_configSchema.schema.string()),
  transactionType: _configSchema.schema.maybe(_configSchema.schema.string()),
  windowSize: _configSchema.schema.number(),
  windowUnit: _configSchema.schema.string(),
  environment: _configSchema.schema.string(),
  anomalySeverityType: _configSchema.schema.oneOf([_configSchema.schema.literal(_anomaly_severity.ML_ANOMALY_SEVERITY.CRITICAL), _configSchema.schema.literal(_anomaly_severity.ML_ANOMALY_SEVERITY.MAJOR), _configSchema.schema.literal(_anomaly_severity.ML_ANOMALY_SEVERITY.MINOR), _configSchema.schema.literal(_anomaly_severity.ML_ANOMALY_SEVERITY.WARNING)]),
  anomalyDetectorTypes: _configSchema.schema.maybe(_configSchema.schema.arrayOf(detectorsSchema, {
    minSize: 1
  }))
});