"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isLegacySemanticTextVersion = void 0;
var _semver = _interopRequireDefault(require("semver"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * checks if the provided manifest version was a version where legacy semantic_text behavior was being used
 */
const isLegacySemanticTextVersion = manifestVersion => {
  return _semver.default.lte(manifestVersion, '1.0.0');
};
exports.isLegacySemanticTextVersion = isLegacySemanticTextVersion;