"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  getPalettes: true
};
exports.getPalettes = void 0;
var _palettes = require("../classes/palettes");
var _categorical = require("./categorical");
var _legacy = require("./legacy");
var _gradient = require("./gradient");
var _get_kbn_palettes = require("./get_kbn_palettes");
Object.keys(_get_kbn_palettes).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _get_kbn_palettes[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _get_kbn_palettes[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const darkKbnPalettes = new _palettes.KbnPalettes([_categorical.kibana7Palette, _legacy.kibana4Palette, _categorical.kibana7BehindText, (0, _categorical.getNeutralPalette)(true), _gradient.complementaryPalette, _gradient.coolPalette, _gradient.grayPalette, _gradient.greenPalette, _gradient.redPalette, _gradient.statusPalette, _gradient.temperaturePalette, _gradient.warmPalette, _legacy.elasticClassicPalette, _gradient.compareToPalette], _categorical.kibana7Palette);
const lightKbnPalettes = new _palettes.KbnPalettes([_categorical.kibana7Palette, _legacy.kibana4Palette, _categorical.kibana7BehindText, (0, _categorical.getNeutralPalette)(false), _gradient.complementaryPalette, _gradient.coolPalette, _gradient.grayPalette, _gradient.greenPalette, _gradient.redPalette, _gradient.statusPalette, _gradient.temperaturePalette, _gradient.warmPalette, _legacy.elasticClassicPalette, _gradient.compareToPalette], _categorical.kibana7Palette);
const getPalettes = darkMode => darkMode ? darkKbnPalettes : lightKbnPalettes;
exports.getPalettes = getPalettes;