"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _default = require("./layouts/default");
var _routes = require("../routes");
var _hooks = require("../common/hooks");
var _empty_state = require("./empty_state");
var _main_navigation = require("./main_navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OsqueryAppComponent = () => {
  const {
    customBranding
  } = (0, _public.useKibana)().services;
  const {
    data: osqueryIntegration,
    isFetched
  } = (0, _hooks.useOsqueryIntegrationStatus)();
  const hasCustomBranding = (0, _useObservable.default)((customBranding === null || customBranding === void 0 ? void 0 : customBranding.hasCustomBranding$) || (0, _rxjs.of)(false), false);
  if (!isFetched) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
      paddingSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      paddingSize: "none",
      color: "subdued"
    }, hasCustomBranding ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xxl"
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
      size: "xxl"
    }))));
  }
  if (isFetched && (osqueryIntegration === null || osqueryIntegration === void 0 ? void 0 : osqueryIntegration.install_status) !== 'installed') {
    return /*#__PURE__*/_react.default.createElement(_empty_state.OsqueryAppEmptyState, null);
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: _default.containerCss,
    id: "osquery-app"
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: _default.wrapperCss
  }, /*#__PURE__*/_react.default.createElement(_main_navigation.MainNavigation, null), /*#__PURE__*/_react.default.createElement(_routes.OsqueryAppRoutes, null)));
};
const OsqueryApp = exports.OsqueryApp = /*#__PURE__*/_react.default.memo(OsqueryAppComponent);