"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAnnotationsPrivileges = useAnnotationsPrivileges;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../../utils/kibana_react");
var _use_annotation_permissions = require("../../components/annotations/hooks/use_annotation_permissions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAnnotationsPrivileges() {
  const {
    data: permissions,
    isLoading
  } = (0, _use_annotation_permissions.useAnnotationPermissions)();
  if (permissions && !isLoading && !(permissions !== null && permissions !== void 0 && permissions.read)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center",
      style: {
        height: 'calc(100vh - 150px)'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(Unprivileged, {
      unprivilegedIndices: [permissions.index]
    })));
  }
  if (!isLoading && !(permissions !== null && permissions !== void 0 && permissions.hasGoldLicense)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center",
      style: {
        height: 'calc(100vh - 150px)'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(LicenseExpired, null)));
  }
  return null;
}
function Unprivileged({
  unprivilegedIndices
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "syntheticsUnprivileged",
    color: "plain",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoObservability",
      size: "xl"
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.noFindingsStates.unprivileged.unprivilegedTitle",
      defaultMessage: "Privileges required"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.noFindingsStates.unprivileged.unprivilegedDescription",
      defaultMessage: "To view Observability annotations data, you must update privileges. For more information, contact your Kibana administrator."
    })),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
      css: (0, _react2.css)`
            text-align: initial;
          `,
      children: _i18n.i18n.translate('xpack.observability.noFindingsStates.unprivileged.unprivilegedFooterMarkdown', {
        defaultMessage: 'Required Elasticsearch index privilege `read` for the following indices:'
      }) + unprivilegedIndices.map(idx => `\n- \`${idx}\``)
    })
  });
}
function LicenseExpired() {
  var _useKibana$services$l;
  const licenseManagementEnabled = (_useKibana$services$l = (0, _kibana_react.useKibana)().services.licenseManagement) === null || _useKibana$services$l === void 0 ? void 0 : _useKibana$services$l.enabled;
  const {
    http: {
      basePath
    }
  } = (0, _kibana_react.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "syntheticsUnprivileged",
    iconType: "warning",
    iconColor: "warning",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.license.invalidLicenseTitle",
      defaultMessage: "Invalid License"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.license.invalidLicenseDescription",
      defaultMessage: "You need a Gold license to view Observability annotations data. For more information, contact your Kibana administrator."
    })),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "aria-label": _i18n.i18n.translate('xpack.observability.invalidLicense.manageYourLicenseButton', {
        defaultMessage: 'Navigate to license management'
      }),
      "data-test-subj": "apmInvalidLicenseNotificationManageYourLicenseButton",
      isDisabled: !licenseManagementEnabled,
      href: basePath + '/app/management/stack/license_management'
    }, _i18n.i18n.translate('xpack.observability.invalidLicense.licenseManagementLink', {
      defaultMessage: 'Manage your license'
    }))]
  });
}