"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KubernetesPage = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _kubernetes = require("../quickstart_flows/kubernetes");
var _template = require("./template");
var _header = require("../header");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KubernetesPage = () => /*#__PURE__*/_react.default.createElement(_template.PageTemplate, {
  customHeader: /*#__PURE__*/_react.default.createElement(_header.CustomHeader, {
    logo: "kubernetes",
    headlineCopy: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.customHeader.kubernetes.text', {
      defaultMessage: 'Monitor your Kubernetes Cluster with standalone Elastic Agent'
    }),
    captionCopy: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.customHeader.kubernetes.caption.description', {
      defaultMessage: 'This installation is tailored for configuring and collecting metrics and logs by deploying a new Elastic Agent within your host.'
    })
  })
}, /*#__PURE__*/_react.default.createElement(_kubernetes.KubernetesPanel, null));
exports.KubernetesPage = KubernetesPage;