"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SparkPlot = SparkPlot;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _dataService = require("@kbn/data-service");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _use_chart_theme = require("../../hooks/use_chart_theme");
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AnnotationTooltip({
  timestamp,
  label
}) {
  const dateFormat = (0, _use_kibana.useKibana)().services.uiSettings.get(_dataService.UI_SETTINGS.DATE_FORMAT);
  const formattedTime = (0, _moment.default)(timestamp).format(dateFormat);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, formattedTime), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, label)));
}
function SparkPlot({
  type,
  timeseries,
  annotations,
  compressed
}) {
  const defaultChartTheme = (0, _use_chart_theme.useChartTheme)();
  const sparkplotChartTheme = {
    chartMargins: {
      left: 0,
      right: 0,
      top: 0,
      bottom: 0
    },
    chartPaddings: {
      top: 12,
      bottom: 12
    },
    lineSeriesStyle: {
      point: {
        opacity: 0
      }
    },
    areaSeriesStyle: {
      point: {
        opacity: 0
      }
    }
  };
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      width: 128,
      height: compressed ? 64 : 48
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: [sparkplotChartTheme, ...defaultChartTheme.theme],
    baseTheme: defaultChartTheme.baseTheme,
    showLegend: false,
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: "none"
  }), type && type === 'bar' ? /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "Sparkbar",
    xScaleType: _charts.ScaleType.Linear,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    data: timeseries
  }) : /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    id: "Sparkline"
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 'x',
    yAccessors: ['y'],
    data: timeseries,
    curve: _charts.CurveType.CURVE_MONOTONE_X
  }), annotations === null || annotations === void 0 ? void 0 : annotations.map(annotation => {
    return /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
      key: annotation.id,
      id: annotation.id,
      dataValues: [{
        dataValue: annotation.x,
        header: ''
      }],
      domainType: _charts.AnnotationDomainType.XDomain,
      marker: annotation.icon,
      markerPosition: _charts.Position.Bottom,
      style: {
        line: {
          strokeWidth: 2,
          stroke: annotation.color
        }
      },
      customTooltip: ({
        datum
      }) => {
        return /*#__PURE__*/_react.default.createElement(AnnotationTooltip, {
          timestamp: datum.dataValue,
          label: annotation.label
        });
      }
    });
  }));
}