"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveEmbeddableAnomalyChartsUserInput = resolveEmbeddableAnomalyChartsUserInput;
var _react = _interopRequireDefault(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _presentationContainers = require("@kbn/presentation-containers");
var _public = require("@kbn/kibana-react-plugin/public");
var _http_service = require("../../application/services/http_service");
var _anomaly_charts_initializer = require("./anomaly_charts_initializer");
var _jobs = require("../../application/services/ml_api_service/jobs");
var _get_services = require("../../application/util/get_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function resolveEmbeddableAnomalyChartsUserInput(coreStart, pluginStart, parentApi, focusedPanelId, input) {
  const {
    http,
    overlays,
    ...startServices
  } = coreStart;
  const adJobsApiService = (0, _jobs.jobsApiProvider)(new _http_service.HttpService(http));
  const mlServices = (0, _get_services.getMlGlobalServices)(coreStart, pluginStart.data.dataViews);
  const overlayTracker = (0, _presentationContainers.tracksOverlays)(parentApi) ? parentApi : undefined;
  return new Promise(async (resolve, reject) => {
    try {
      const flyoutSession = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
        services: {
          ...coreStart,
          ...pluginStart,
          mlServices
        }
      }, /*#__PURE__*/_react.default.createElement(_anomaly_charts_initializer.AnomalyChartsInitializer, {
        initialInput: input,
        onCreate: ({
          jobIds,
          title,
          maxSeriesToPlot
        }) => {
          resolve({
            jobIds,
            title,
            maxSeriesToPlot
          });
          flyoutSession.close();
          overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
        },
        onCancel: () => {
          reject();
          flyoutSession.close();
          overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
        },
        adJobsApiService: adJobsApiService
      })), startServices), {
        type: 'push',
        ownFocus: true,
        size: 's',
        onClose: () => {
          reject();
          flyoutSession.close();
          overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
        },
        'data-test-subj': 'mlAnomalyChartsEmbeddableInitializer'
      });
      if ((0, _presentationContainers.tracksOverlays)(parentApi)) {
        parentApi.openOverlay(flyoutSession, {
          focusedPanelId
        });
      }
    } catch (error) {
      reject(error);
    }
  });
}