"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeseriesExplorerStyles = exports.getAnnotationStyles = void 0;
var _react = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _eui = require("@elastic/eui");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Annotations constants
const mlAnnotationBorderWidth = '2px';
const mlAnnotationRectDefaultStrokeOpacity = 0.2;
const mlAnnotationRectDefaultFillOpacity = 0.05;
const getTimeseriesExplorerStyles = () => (0, _react.css)({
  color: _uiTheme.euiThemeVars.euiColorDarkShade,
  '.ml-timeseries-chart': {
    svg: {
      fontSize: _uiTheme.euiThemeVars.euiFontSizeXS,
      fontFamily: _uiTheme.euiThemeVars.euiFontFamily
    },
    '.axis': {
      'path, line': {
        fill: 'none',
        stroke: _uiTheme.euiThemeVars.euiBorderColor,
        shapeRendering: 'crispEdges',
        pointerEvents: 'none'
      },
      text: {
        fill: _uiTheme.euiThemeVars.euiTextColor
      },
      '.tick line': {
        stroke: _uiTheme.euiThemeVars.euiColorLightShade
      }
    },
    '.chart-border': {
      stroke: _uiTheme.euiThemeVars.euiBorderColor,
      fill: 'none',
      strokeWidth: 1,
      shapeRendering: 'crispEdges'
    },
    '.chart-border-highlight': {
      stroke: _uiTheme.euiThemeVars.euiColorDarkShade,
      strokeWidth: 2,
      '&:hover': {
        opacity: 1
      }
    },
    '.area': {
      strokeWidth: 1,
      '&.bounds': {
        fill: (0, _eui.transparentize)(_uiTheme.euiThemeVars.euiColorPrimary, 0.2),
        pointerEvents: 'none'
      },
      '&.forecast': {
        fill: (0, _eui.transparentize)(_uiTheme.euiThemeVars.euiColorVis5, 0.3),
        pointerEvents: 'none'
      }
    },
    '.values-line': {
      fill: 'none',
      stroke: _uiTheme.euiThemeVars.euiColorPrimary,
      strokeWidth: 2,
      pointerEvents: 'none',
      '&.forecast': {
        stroke: _uiTheme.euiThemeVars.euiColorVis5,
        pointerEvents: 'none'
      }
    },
    '.hidden': {
      visibility: 'hidden'
    },
    '.values-dots circle': {
      fill: _uiTheme.euiThemeVars.euiColorPrimary,
      strokeWidth: 0
    },
    '.metric-value': {
      opacity: 1,
      fill: 'transparent',
      stroke: _uiTheme.euiThemeVars.euiColorPrimary,
      strokeWidth: 0
    },
    '.anomaly-marker': {
      strokeWidth: 1,
      stroke: _uiTheme.euiThemeVars.euiColorMediumShade,
      '&.critical': {
        fill: _mlAnomalyUtils.ML_SEVERITY_COLORS.CRITICAL
      },
      '&.major': {
        fill: _mlAnomalyUtils.ML_SEVERITY_COLORS.MAJOR
      },
      '&.minor': {
        fill: _mlAnomalyUtils.ML_SEVERITY_COLORS.MINOR
      },
      '&.warning': {
        fill: _mlAnomalyUtils.ML_SEVERITY_COLORS.WARNING
      },
      '&.low': {
        fill: _mlAnomalyUtils.ML_SEVERITY_COLORS.LOW
      }
    },
    '.metric-value:hover, .anomaly-marker:hover, .anomaly-marker.highlighted': {
      strokeWidth: 6,
      strokeOpacity: 0.65,
      stroke: _uiTheme.euiThemeVars.euiColorPrimary
    },
    'rect.scheduled-event-marker': {
      strokeWidth: 1,
      stroke: _uiTheme.euiThemeVars.euiColorDarkShade,
      fill: _uiTheme.euiThemeVars.euiColorLightShade
    },
    '.forecast': {
      '.metric-value, .metric-value:hover': {
        stroke: _uiTheme.euiThemeVars.euiColorVis5
      }
    },
    '.focus-chart': {
      '.x-axis-background': {
        line: {
          fill: 'none',
          shapeRendering: 'crispEdges',
          stroke: _uiTheme.euiThemeVars.euiColorLightestShade
        },
        rect: {
          fill: _uiTheme.euiThemeVars.euiColorLightestShade
        }
      },
      '.focus-zoom': {
        fill: _uiTheme.euiThemeVars.euiColorDarkShade,
        a: {
          text: {
            fill: _uiTheme.euiThemeVars.euiColorPrimary,
            cursor: 'pointer'
          },
          '&:hover, &:active, &:focus': {
            textDecoration: 'underline',
            fill: _uiTheme.euiThemeVars.euiColorPrimary
          }
        }
      }
    },
    '.context-chart': {
      '.x.axis path': {
        display: 'none'
      },
      '.axis text': {
        fontSize: '10px',
        fill: _uiTheme.euiThemeVars.euiTextColor
      },
      '.values-line': {
        strokeWidth: 1
      },
      '.mask': {
        polygon: {
          fillOpacity: 0.1
        },
        '.area.bounds': {
          fill: _uiTheme.euiThemeVars.euiColorLightShade
        },
        '.values-line': {
          strokeWidth: 1,
          stroke: _uiTheme.euiThemeVars.euiColorMediumShade
        }
      }
    },
    '.swimlane .axis text': {
      display: 'none'
    },
    '.swimlane rect.swimlane-cell-hidden': {
      display: 'none'
    },
    '.brush .extent': {
      fillOpacity: 0,
      shapeRendering: 'crispEdges',
      stroke: _uiTheme.euiThemeVars.euiColorDarkShade,
      strokeWidth: 2,
      cursor: 'move',
      '&:hover': {
        opacity: 1
      }
    },
    '.top-border': {
      fill: _uiTheme.euiThemeVars.euiColorEmptyShade
    },
    'foreignObject.brush-handle': {
      pointerEvents: 'none',
      paddingTop: '1px'
    },
    'div.brush-handle-inner': {
      border: `1px solid ${_uiTheme.euiThemeVars.euiColorDarkShade}`,
      backgroundColor: _uiTheme.euiThemeVars.euiColorLightShade,
      height: '70px',
      width: '10px',
      textAlign: 'center',
      cursor: 'ew-resize',
      marginTop: '9px',
      fontSize: _uiTheme.euiThemeVars.euiFontSizeS,
      fill: _uiTheme.euiThemeVars.euiColorDarkShade
    },
    'div.brush-handle-inner-left': {
      borderRadius: `${_uiTheme.euiThemeVars.euiBorderRadius} 0 0 ${_uiTheme.euiThemeVars.euiBorderRadius}`
    },
    'div.brush-handle-inner-right': {
      borderRadius: `0 ${_uiTheme.euiThemeVars.euiBorderRadius} ${_uiTheme.euiThemeVars.euiBorderRadius} 0`
    },
    'rect.brush-handle': {
      strokeWidth: 1,
      stroke: _uiTheme.euiThemeVars.euiColorDarkShade,
      fill: _uiTheme.euiThemeVars.euiColorLightShade,
      pointerEvents: 'none',
      '&:hover': {
        opacity: 1
      }
    }
  }
});
exports.getTimeseriesExplorerStyles = getTimeseriesExplorerStyles;
const getAnnotationStyles = () => (0, _react.css)({
  '.ml-annotation': {
    '&__brush': {
      '.extent': {
        stroke: _uiTheme.euiThemeVars.euiColorLightShade,
        strokeWidth: mlAnnotationBorderWidth,
        strokeDasharray: '2 2',
        fill: _uiTheme.euiThemeVars.euiColorLightestShade,
        shapeRendering: 'geometricPrecision'
      }
    },
    '&__rect': {
      stroke: _uiTheme.euiThemeVars.euiColorFullShade,
      strokeWidth: mlAnnotationBorderWidth,
      strokeOpacity: mlAnnotationRectDefaultStrokeOpacity,
      fill: _uiTheme.euiThemeVars.euiColorFullShade,
      fillOpacity: mlAnnotationRectDefaultFillOpacity,
      shapeRendering: 'geometricPrecision',
      transition: `stroke-opacity ${_uiTheme.euiThemeVars.euiAnimSpeedFast}, fill-opacity ${_uiTheme.euiThemeVars.euiAnimSpeedFast}`,
      '&--highlight': {
        strokeOpacity: mlAnnotationRectDefaultStrokeOpacity * 2,
        fillOpacity: mlAnnotationRectDefaultFillOpacity * 2
      },
      '&--blur': {
        strokeOpacity: mlAnnotationRectDefaultStrokeOpacity / 2,
        fillOpacity: mlAnnotationRectDefaultFillOpacity / 2
      }
    },
    '&__text': {
      textAnchor: 'middle',
      fontSize: _uiTheme.euiThemeVars.euiFontSizeXS,
      fontFamily: _uiTheme.euiThemeVars.euiFontFamily,
      fontWeight: _uiTheme.euiThemeVars.euiFontWeightMedium,
      fill: _uiTheme.euiThemeVars.euiColorFullShade,
      transition: `fill ${_uiTheme.euiThemeVars.euiAnimSpeedFast}`,
      userSelect: 'none',
      '&--blur': {
        fill: _uiTheme.euiThemeVars.euiColorMediumShade
      }
    },
    '&__text-rect': {
      fill: _uiTheme.euiThemeVars.euiColorLightShade,
      transition: `fill ${_uiTheme.euiThemeVars.euiAnimSpeedFast}`,
      '&--blur': {
        fill: _uiTheme.euiThemeVars.euiColorLightestShade
      }
    },
    '&--hidden': {
      display: 'none'
    },
    '&__context-rect': {
      stroke: _uiTheme.euiThemeVars.euiColorFullShade,
      strokeWidth: mlAnnotationBorderWidth,
      strokeOpacity: mlAnnotationRectDefaultStrokeOpacity,
      fill: _uiTheme.euiThemeVars.euiColorFullShade,
      fillOpacity: mlAnnotationRectDefaultFillOpacity,
      transition: `stroke-opacity ${_uiTheme.euiThemeVars.euiAnimSpeedFast}, fill-opacity ${_uiTheme.euiThemeVars.euiAnimSpeedFast}`,
      shapeRendering: 'geometricPrecision',
      '&--blur': {
        strokeOpacity: mlAnnotationRectDefaultStrokeOpacity / 2,
        fillOpacity: mlAnnotationRectDefaultFillOpacity / 2
      }
    }
  }
});
exports.getAnnotationStyles = getAnnotationStyles;