"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaTabContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _std = require("@kbn/std");
var _dashboard_service = require("../../services/dashboard_service");
var _kibana = require("../../contexts/kibana");
var _overview_tab_content = require("./overview_tab_content");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KibanaTabContent = ({
  module,
  selectedKibanaSubTab
}) => {
  var _module$kibana4, _module$kibana5, _module$kibana6, _module$kibana7, _module$kibana8;
  const [kibanaAssetUrls, setKibanaAssetUrls] = (0, _react.useState)({});
  const dashboardService = (0, _dashboard_service.useDashboardService)();
  const {
    services: {
      application,
      share
    }
  } = (0, _kibana.useMlKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  (0, _react.useEffect)(function setUpUrls() {
    var _module$kibana$dashbo, _module$kibana, _module$kibana$search, _module$kibana2, _module$kibana$visual, _module$kibana3;
    const dashboards = (_module$kibana$dashbo = (_module$kibana = module.kibana) === null || _module$kibana === void 0 ? void 0 : _module$kibana.dashboard) !== null && _module$kibana$dashbo !== void 0 ? _module$kibana$dashbo : [];
    const dashboardIds = dashboards.map(({
      id
    }) => id);
    const savedSearchIds = ((_module$kibana$search = (_module$kibana2 = module.kibana) === null || _module$kibana2 === void 0 ? void 0 : _module$kibana2.search) !== null && _module$kibana$search !== void 0 ? _module$kibana$search : []).map(({
      id
    }) => id);
    const visualizationIds = ((_module$kibana$visual = (_module$kibana3 = module.kibana) === null || _module$kibana3 === void 0 ? void 0 : _module$kibana3.visualization) !== null && _module$kibana$visual !== void 0 ? _module$kibana$visual : []).map(({
      id
    }) => id);
    const allUrls = {};
    async function getUrls() {
      if (dashboards.length > 0) {
        const result = await dashboardService.fetchDashboardsById(dashboardIds);
        await (0, _std.asyncForEach)(result, async ({
          id
        }) => {
          const url = await dashboardService.getDashboardUrl(id, 'view');
          if (url) {
            allUrls[id] = url;
          }
        });
      }
      if (savedSearchIds.length > 0) {
        const discoverLocator = share.url.locators.get('DISCOVER_APP_LOCATOR');
        if (discoverLocator) {
          savedSearchIds.forEach(id => {
            const url = discoverLocator.getRedirectUrl({
              savedSearchId: id
            });
            if (url) {
              allUrls[id] = url;
            }
          });
        }
      }
      if (visualizationIds.length > 0) {
        visualizationIds.forEach(id => {
          const url = application.getUrlForApp('visualize#', {
            path: `edit/${id}`
          });
          if (url) {
            allUrls[id] = url;
          }
        });
      }
      if (Object.keys(allUrls).length > 0) {
        setKibanaAssetUrls(allUrls);
      }
    }
    getUrls();
  }, [dashboardService, (_module$kibana4 = module.kibana) === null || _module$kibana4 === void 0 ? void 0 : _module$kibana4.dashboard, share === null || share === void 0 ? void 0 : share.url.locators, (_module$kibana5 = module.kibana) === null || _module$kibana5 === void 0 ? void 0 : _module$kibana5.discover, (_module$kibana6 = module.kibana) === null || _module$kibana6 === void 0 ? void 0 : _module$kibana6.search, (_module$kibana7 = module.kibana) === null || _module$kibana7 === void 0 ? void 0 : _module$kibana7.visualization, application]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Object.entries((_module$kibana8 = module.kibana) !== null && _module$kibana8 !== void 0 ? _module$kibana8 : {}).map(([assetId, asset]) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: assetId,
      initialIsOpen: assetId === selectedKibanaSubTab,
      buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "center",
        alignItems: "center",
        gutterSize: "s",
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "m"
      }, /*#__PURE__*/_react.default.createElement("h4", null, _overview_tab_content.LABELS[assetId]))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
        color: "subdued",
        size: "m"
      }, /*#__PURE__*/_react.default.createElement("h3", null, module.kibana[assetId].length)))),
      css: {
        padding: `0 ${euiTheme.size.m}`
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
      hasBorder: true,
      hasShadow: false,
      "data-test-subj": `mlPreconfigJobsKibanaAssetAccordion.${assetId}`
    }, (asset !== null && asset !== void 0 ? asset : []).map(({
      config,
      id,
      title
    }) => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
        grow: false,
        key: id,
        "data-test-subj": `mlPreconfigJobsKibanaAssetAccordion.${assetId}.${id}`
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "m"
      }, /*#__PURE__*/_react.default.createElement("p", null, kibanaAssetUrls && kibanaAssetUrls[id] ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: kibanaAssetUrls[id],
        target: "_blank"
      }, title) : title)), config.description && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("p", null, config.description)))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        margin: "none"
      }));
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }));
  }));
};
exports.KibanaTabContent = KibanaTabContent;