"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SplitFieldSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _split_field_select = require("../split_field_select");
var _job_creator_context = require("../../../job_creator_context");
var _fields_utils = require("../../../../../../../../../common/util/fields_utils");
var _new_job_capabilities_service = require("../../../../../../../services/new_job_capabilities/new_job_capabilities_service");
var _description = require("./description");
var _job_creator = require("../../../../../common/job_creator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SplitFieldSelector = () => {
  const {
    jobCreator: jc,
    jobCreatorUpdate,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const newJobCapsService = (0, _new_job_capabilities_service.useNewJobCapsService)();

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const runtimeCategoryFields = (0, _react.useMemo)(() => (0, _fields_utils.filterCategoryFields)(jobCreator.runtimeFields), []);
  const allCategoryFields = (0, _react.useMemo)(() => [...newJobCapsService.categoryFields, ...runtimeCategoryFields].sort((a, b) => a.name.localeCompare(b.name)),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const categoryFields = useFilteredCategoryFields(allCategoryFields, jobCreator, jobCreatorUpdated);
  const [splitField, setSplitField] = (0, _react.useState)(jobCreator.splitField);
  (0, _react.useEffect)(() => {
    jobCreator.setSplitField(splitField);
    // add the split field to the influencers
    if (splitField !== null && jobCreator.influencers.includes(splitField.name) === false) {
      jobCreator.addInfluencer(splitField.name);
    }
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [splitField]);
  (0, _react.useEffect)(() => {
    setSplitField(jobCreator.splitField);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_description.Description, null, /*#__PURE__*/_react.default.createElement(_split_field_select.SplitFieldSelect, {
    fields: categoryFields,
    changeHandler: setSplitField,
    selectedField: splitField,
    isClearable: true,
    testSubject: "mlSplitFieldSelect"
  }));
};

// remove the rare (by) and population (over) fields from the by field options in the rare wizard
exports.SplitFieldSelector = SplitFieldSelector;
function useFilteredCategoryFields(allCategoryFields, jobCreator, jobCreatorUpdated) {
  const [fields, setFields] = (0, _react.useState)(allCategoryFields);
  (0, _react.useEffect)(() => {
    if ((0, _job_creator.isMultiMetricJobCreator)(jobCreator)) {
      setFields(allCategoryFields);
    } else {
      const rf = jobCreator.rareField;
      const pf = jobCreator.populationField;
      if (rf !== null || pf !== null) {
        setFields(allCategoryFields.filter(({
          name
        }) => name !== (rf === null || rf === void 0 ? void 0 : rf.name) && name !== (pf === null || pf === void 0 ? void 0 : pf.name)));
      } else {
        setFields(allCategoryFields);
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  return fields;
}