"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartGrid = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _split_cards = require("../split_cards");
var _detector_title = require("../detector_title");
var _anomaly_chart = require("../../../charts/anomaly_chart");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChartGrid = ({
  aggFieldPairList,
  chartSettings,
  splitField,
  fieldValues,
  lineChartsData,
  modelData,
  anomalyData,
  deleteDetector,
  jobType,
  loading = false
}) => {
  const animateSplit = (0, _split_cards.useAnimateSplit)();
  return /*#__PURE__*/_react.default.createElement(_split_cards.SplitCards, {
    fieldValues: fieldValues,
    splitField: splitField,
    numberOfDetectors: aggFieldPairList.length,
    jobType: jobType,
    animate: animateSplit
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: chartSettings.cols
  }, aggFieldPairList.map((af, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: i,
    "data-test-subj": `mlDetector ${i}`
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_detector_title.DetectorTitle, {
    index: i,
    agg: aggFieldPairList[i].agg,
    field: aggFieldPairList[i].field,
    deleteDetector: deleteDetector
  }), /*#__PURE__*/_react.default.createElement(_anomaly_chart.AnomalyChart, {
    chartType: _anomaly_chart.CHART_TYPE.LINE,
    chartData: lineChartsData[i],
    modelData: modelData[i],
    anomalyData: anomalyData[i],
    height: chartSettings.height,
    width: chartSettings.width,
    loading: loading
  }))))));
};
exports.ChartGrid = ChartGrid;