"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsTableFlyoutBody = void 0;
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _alerts_table_context = require("@kbn/response-ops-alerts-table/contexts/alerts_table_context");
var _render_cell_value = require("./render_cell_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertsTableFlyoutBody = ({
  alert,
  columns
}) => {
  const {
    services: {
      fieldFormats
    }
  } = (0, _alerts_table_context.useAlertsTableContext)();
  const formatter = (0, _render_cell_value.getAlertFormatters)(fieldFormats);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: columns.map(column => {
      const alertFieldValue = (0, _lodash.get)(alert, column.id);
      const value = Array.isArray(alertFieldValue) ? alertFieldValue.at(-1) : alertFieldValue;
      return {
        title: column.displayAsText,
        description: (0, _mlIsDefined.isDefined)(value) ? formatter(column.id, value) : '—'
      };
    }),
    type: "column",
    columnWidths: [1, 3] // Same as [25, 75]
  }));
};
exports.AlertsTableFlyoutBody = AlertsTableFlyoutBody;