"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ML_ANOMALY_THRESHOLD = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Anomaly score numeric thresholds to indicate the severity of the anomaly.
 */
let ML_ANOMALY_THRESHOLD = exports.ML_ANOMALY_THRESHOLD = /*#__PURE__*/function (ML_ANOMALY_THRESHOLD) {
  ML_ANOMALY_THRESHOLD[ML_ANOMALY_THRESHOLD["CRITICAL"] = 75] = "CRITICAL";
  ML_ANOMALY_THRESHOLD[ML_ANOMALY_THRESHOLD["MAJOR"] = 50] = "MAJOR";
  ML_ANOMALY_THRESHOLD[ML_ANOMALY_THRESHOLD["MINOR"] = 25] = "MINOR";
  ML_ANOMALY_THRESHOLD[ML_ANOMALY_THRESHOLD["WARNING"] = 3] = "WARNING";
  ML_ANOMALY_THRESHOLD[ML_ANOMALY_THRESHOLD["LOW"] = 0] = "LOW";
  return ML_ANOMALY_THRESHOLD;
}({});