"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyleMeta = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StyleMeta {
  constructor(styleMetaDescriptor) {
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    this._descriptor = styleMetaDescriptor ? styleMetaDescriptor : {
      fieldMeta: {}
    };
  }
  getRangeFieldMetaDescriptor(fieldName) {
    return this._descriptor.fieldMeta[fieldName] && this._descriptor.fieldMeta[fieldName].range ? this._descriptor.fieldMeta[fieldName].range : null;
  }
  getCategoryFieldMetaDescriptor(fieldName) {
    return this._descriptor.fieldMeta[fieldName] ? this._descriptor.fieldMeta[fieldName].categories : [];
  }
  isPointsOnly() {
    return this._descriptor.geometryTypes ? !!this._descriptor.geometryTypes.isPointsOnly : false;
  }
  isLinesOnly() {
    return this._descriptor.geometryTypes ? !!this._descriptor.geometryTypes.isLinesOnly : false;
  }
  isPolygonsOnly() {
    return this._descriptor.geometryTypes ? !!this._descriptor.geometryTypes.isPolygonsOnly : false;
  }
}
exports.StyleMeta = StyleMeta;