"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLayerDescriptor = createLayerDescriptor;
var _constants = require("../../../../common/constants");
var _es_search_source = require("./es_search_source");
var _vector_layer = require("../../layers/vector_layer");
var _licensed_features = require("../../../licensed_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createLayerDescriptor({
  indexPatternId,
  geoFieldName,
  geoFieldType,
  query
}) {
  // Prefer clusters for geo_shapes if liscensing is enabled.
  const scalingType = geoFieldType === _constants.ES_GEO_FIELD_TYPE.GEO_POINT || geoFieldType === _constants.ES_GEO_FIELD_TYPE.GEO_SHAPE && (0, _licensed_features.getIsGoldPlus)() ? _constants.SCALING_TYPES.CLUSTERS : _constants.SCALING_TYPES.LIMIT;
  const sourceDescriptor = _es_search_source.ESSearchSource.createDescriptor({
    indexPatternId,
    geoField: geoFieldName,
    scalingType
  });
  return _vector_layer.GeoJsonVectorLayer.createDescriptor({
    sourceDescriptor,
    query
  });
}