"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Dataset = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Dataset {
  constructor(dataset, parentIntegration) {
    var _dataset$title, _parentIntegration$ti;
    (0, _defineProperty2.default)(this, "id", void 0);
    (0, _defineProperty2.default)(this, "iconType", void 0);
    (0, _defineProperty2.default)(this, "name", void 0);
    (0, _defineProperty2.default)(this, "title", void 0);
    (0, _defineProperty2.default)(this, "parentIntegration", void 0);
    this.id = `dataset-${dataset.name}`;
    this.iconType = dataset.iconType;
    this.name = dataset.name;
    this.title = (_dataset$title = dataset.title) !== null && _dataset$title !== void 0 ? _dataset$title : dataset.name;
    this.parentIntegration = parentIntegration && {
      name: parentIntegration.name,
      title: (_parentIntegration$ti = parentIntegration.title) !== null && _parentIntegration$ti !== void 0 ? _parentIntegration$ti : parentIntegration.name,
      icons: parentIntegration.icons,
      version: parentIntegration.version
    };
  }
  getFullTitle() {
    var _this$parentIntegrati;
    return (_this$parentIntegrati = this.parentIntegration) !== null && _this$parentIntegrati !== void 0 && _this$parentIntegrati.title ? `[${this.parentIntegration.title}] ${this.title}` : this.title;
  }
  getDatasetWildcard() {
    const [type, dataset, _namespace] = this.name.split('-');
    return `${type}-${dataset}-*`;
  }
  toDataviewSpec() {
    // Invert the property because the API returns the index pattern as `name` and a readable name as `title`
    return {
      id: this.id,
      name: this.getFullTitle(),
      timeFieldName: _constants.TIMESTAMP_FIELD,
      title: this.name
    };
  }
  toPlain() {
    return {
      name: this.name,
      title: this.title
    };
  }
  static create(dataset, parentIntegration) {
    const datasetTitle = dataset.title || dataset.name.split('-')[1];
    return new Dataset({
      ...dataset,
      title: datasetTitle
    }, parentIntegration);
  }
  static createAllLogsDataset({
    indices
  }) {
    return new Dataset({
      name: indices,
      title: 'All logs',
      iconType: 'pagesSelect'
    });
  }
  static createWildcardDatasetsFrom(datasets) {
    // Gather unique list of wildcards
    const wildcards = datasets.reduce((list, dataset) => list.add(dataset.getDatasetWildcard()), new Set());

    // Create new datasets for the retrieved wildcards
    return Array.from(wildcards).map(wildcard => Dataset.create({
      name: wildcard
    }));
  }
}
exports.Dataset = Dataset;