"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsClientChatBedrockConverse = void 0;
var _aws = require("@langchain/aws");
var _bedrock_runtime_client = require("./bedrock_runtime_client");
var _bedrock = require("../../utils/bedrock");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Custom chat model class for Bedrock Converse API.
 * The ActionsClientChatBedrockConverse chat model supports streaming and
 * non-streaming via the Bedrock Converse and ConverseStream APIs.
 *
 * @param {Object} params - The parameters for the chat model.
 * @param {ActionsClient} params.actionsClient - The actions client.
 * @param {string} params.connectorId - The connector ID.
 * @param {Logger} params.logger - The logger instance.
 * @param {AbortSignal} [params.signal] - Optional abort signal.
 * @param {string} [params.model] - Optional model name.
 */
class ActionsClientChatBedrockConverse extends _aws.ChatBedrockConverse {
  constructor({
    actionsClient,
    connectorId,
    logger,
    ...fields
  }) {
    var _fields$model;
    super({
      ...(fields !== null && fields !== void 0 ? fields : {}),
      credentials: {
        accessKeyId: '',
        secretAccessKey: ''
      },
      // if no model is passed in the body, the connector is preconfigured and the model needs to be set on the server
      model: (_fields$model = fields === null || fields === void 0 ? void 0 : fields.model) !== null && _fields$model !== void 0 ? _fields$model : 'preconfigured',
      region: _bedrock.DEFAULT_BEDROCK_REGION
    });
    this.client = new _bedrock_runtime_client.BedrockRuntimeClient({
      actionsClient,
      connectorId,
      streaming: this.streaming,
      region: _bedrock.DEFAULT_BEDROCK_REGION,
      telemetryMetadata: fields === null || fields === void 0 ? void 0 : fields.telemetryMetadata
    });
  }
}
exports.ActionsClientChatBedrockConverse = ActionsClientChatBedrockConverse;