"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Synopsis = Synopsis;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function Synopsis({
  id,
  description,
  iconUrl,
  iconType,
  title,
  url,
  wrapInPanel,
  onClick,
  isBeta
}) {
  let optionalImg;
  if (iconUrl) {
    optionalImg = /*#__PURE__*/_react.default.createElement("img", {
      alt: "",
      className: "synopsisIcon",
      src: iconUrl
    });
  } else if (iconType) {
    optionalImg = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "text",
      size: "l",
      title: "",
      type: iconType
    });
  }
  const classes = (0, _classnames.default)('homSynopsis__card', {
    'homSynopsis__card--noPanel': !wrapInPanel
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    className: classes,
    layout: "horizontal",
    icon: optionalImg,
    titleSize: "xs",
    title: title,
    description: description,
    onClick: onClick,
    href: url,
    "data-test-subj": `homeSynopsisLink${id.toLowerCase()}`,
    betaBadgeProps: {
      label: isBeta ? 'Beta' : null
    },
    titleElement: "h3"
  });
}
Synopsis.propTypes = {
  description: _propTypes.default.string.isRequired,
  iconUrl: _propTypes.default.string,
  iconType: _propTypes.default.string,
  title: _propTypes.default.string.isRequired,
  url: _propTypes.default.string,
  onClick: _propTypes.default.func,
  isBeta: _propTypes.default.bool
};
Synopsis.defaultProps = {
  isBeta: false
};