"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleGetStateDetails = handleGetStateDetails;
var _output_parsers = require("@langchain/core/output_parsers");
var _constants = require("./constants");
var _prompts = require("./prompts");
var _util = require("./util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleGetStateDetails({
  state,
  model
}) {
  const outputParser = new _output_parsers.JsonOutputParser();
  const celConfigGraph = _prompts.CEL_CONFIG_DETAILS_PROMPT.pipe(model).pipe(outputParser);
  const stateDetails = await celConfigGraph.invoke({
    state_variables: state.stateVarNames,
    open_api_spec: state.apiDefinition,
    ex_answer: _constants.EX_ANSWER_CONFIG
  });
  const stateSettings = (0, _util.getStateVarsAndDefaultValues)(stateDetails);
  const redactVars = (0, _util.getRedactVariables)(stateDetails);
  return {
    stateSettings,
    redactVars,
    lastExecutedChain: 'getStateDetails'
  };
}