"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logEntryCategoryExamplesResponseRT = exports.logEntryCategoryExampleHitRT = exports.createLogEntryCategoryExamplesQuery = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _elasticsearch_runtime_types = require("../../../utils/elasticsearch_runtime_types");
var _common = require("./common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createLogEntryCategoryExamplesQuery = (indices, runtimeMappings, timestampField, tiebreakerField, startTime, endTime, categoryQuery, exampleCount) => ({
  ..._common.defaultRequestParameters,
  body: {
    size: exampleCount,
    query: {
      bool: {
        filter: [{
          range: {
            [timestampField]: {
              gte: startTime,
              lte: endTime,
              format: 'epoch_millis'
            }
          }
        }, {
          match: {
            message: {
              query: categoryQuery,
              operator: 'and'
            }
          }
        }]
      }
    },
    runtime_mappings: runtimeMappings,
    sort: [{
      [timestampField]: 'asc'
    }, {
      [tiebreakerField]: 'asc'
    }],
    _source: false,
    fields: ['event.dataset', 'message', 'container.id', 'host.name', 'log.file.path']
  },
  index: indices
});
exports.createLogEntryCategoryExamplesQuery = createLogEntryCategoryExamplesQuery;
const logEntryCategoryExampleHitRT = exports.logEntryCategoryExampleHitRT = rt.type({
  _id: rt.string,
  fields: rt.partial({
    'event.dataset': rt.array(rt.string),
    message: rt.array(rt.string),
    'container.id': rt.array(rt.string),
    'host.name': rt.array(rt.string),
    'log.file.path': rt.array(rt.string)
  }),
  sort: rt.tuple([rt.number, rt.number])
});
const logEntryCategoryExamplesResponseRT = exports.logEntryCategoryExamplesResponseRT = rt.intersection([_elasticsearch_runtime_types.commonSearchSuccessResponseFieldsRT, rt.type({
  hits: rt.type({
    hits: rt.array(logEntryCategoryExampleHitRT)
  })
})]);

// eslint-disable-next-line @typescript-eslint/naming-convention