"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateStringNotEmpty = exports.validateStringNoSpaces = exports.validateIndexPatternIsntRollup = exports.validateIndexPatternIsTimeBased = exports.validateIndexPatternHasStringMessageField = exports.validateIndexPattern = exports.validateColumnListNotEmpty = void 0;
var _public = require("@kbn/data-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateStringNotEmpty = (fieldName, value) => value === '' ? [{
  type: 'empty_field',
  fieldName
}] : [];
exports.validateStringNotEmpty = validateStringNotEmpty;
const validateStringNoSpaces = (fieldName, value) => value.includes(' ') ? [{
  type: 'includes_spaces',
  fieldName
}] : [];
exports.validateStringNoSpaces = validateStringNoSpaces;
const validateColumnListNotEmpty = columns => columns.length <= 0 ? [{
  type: 'empty_column_list'
}] : [];
exports.validateColumnListNotEmpty = validateColumnListNotEmpty;
const validateIndexPattern = indexPattern => {
  return [...validateIndexPatternIsTimeBased(indexPattern), ...validateIndexPatternHasStringMessageField(indexPattern), ...validateIndexPatternIsntRollup(indexPattern)];
};
exports.validateIndexPattern = validateIndexPattern;
const validateIndexPatternIsTimeBased = indexPattern => indexPattern.isTimeBased() ? [] : [{
  type: 'missing_timestamp_field',
  indexPatternTitle: indexPattern.getIndexPattern()
}];
exports.validateIndexPatternIsTimeBased = validateIndexPatternIsTimeBased;
const validateIndexPatternHasStringMessageField = indexPattern => {
  const messageField = indexPattern.getFieldByName('message');
  if (messageField == null) {
    return [{
      type: 'missing_message_field',
      indexPatternTitle: indexPattern.getIndexPattern()
    }];
  } else if (messageField.type !== _public.KBN_FIELD_TYPES.STRING) {
    return [{
      type: 'invalid_message_field_type',
      indexPatternTitle: indexPattern.getIndexPattern()
    }];
  } else {
    return [];
  }
};
exports.validateIndexPatternHasStringMessageField = validateIndexPatternHasStringMessageField;
const validateIndexPatternIsntRollup = indexPattern => indexPattern.type != null ? [{
  type: 'rollup_index_pattern',
  indexPatternTitle: indexPattern.getIndexPattern()
}] : [];
exports.validateIndexPatternIsntRollup = validateIndexPatternIsntRollup;