"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithLogTextviewUrlState = void 0;
var _react = _interopRequireWildcard(require("react"));
var _url_state = require("../../utils/url_state");
var _log_view_configuration = require("./log_view_configuration");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WithLogTextviewUrlState = () => {
  const {
    textScale,
    textWrap,
    setTextScale,
    setTextWrap
  } = (0, _log_view_configuration.useLogViewConfigurationContext)();
  const urlState = (0, _react.useMemo)(() => ({
    textScale,
    wrap: textWrap
  }), [textScale, textWrap]);
  return /*#__PURE__*/_react.default.createElement(_url_state.UrlStateContainer, {
    urlState: urlState,
    urlStateKey: "logTextview",
    mapToUrlState: mapToUrlState,
    onChange: newUrlState => {
      if (newUrlState && newUrlState.textScale) {
        setTextScale(newUrlState.textScale);
      }
      if (newUrlState && typeof newUrlState.wrap !== 'undefined') {
        setTextWrap(newUrlState.wrap);
      }
    },
    onInitialize: newUrlState => {
      if (newUrlState && newUrlState.textScale) {
        setTextScale(newUrlState.textScale);
      }
      if (newUrlState && typeof newUrlState.wrap !== 'undefined') {
        setTextWrap(newUrlState.wrap);
      }
    }
  });
};
exports.WithLogTextviewUrlState = WithLogTextviewUrlState;
const mapToUrlState = value => value ? {
  textScale: mapToTextScaleUrlState(value.textScale),
  wrap: mapToWrapUrlState(value.wrap)
} : undefined;
const mapToTextScaleUrlState = value => _log_view_configuration.availableTextScales.includes(value) ? value : undefined;
const mapToWrapUrlState = value => typeof value === 'boolean' ? value : undefined;