"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeRuler = void 0;
var _d3Scale = require("d3-scale");
var React = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _use_kibana_time_zone_setting = require("../../../hooks/use_kibana_time_zone_setting");
var _time_label_formatter = require("./time_label_formatter");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useZonedDate = timestamp => {
  const timeZone = (0, _use_kibana_time_zone_setting.useKibanaTimeZoneSetting)();
  const options = timeZone !== 'local' ? {
    timeZone
  } : undefined;
  return new Date(new Date(timestamp).toLocaleString('en-US', options));
};
const TimeRuler = ({
  end,
  height,
  start,
  tickCount,
  width
}) => {
  const startWithOffset = useZonedDate(start);
  const endWithOffset = useZonedDate(end);
  const yScale = (0, _d3Scale.scaleTime)().domain([startWithOffset, endWithOffset]).range([0, height]);
  const ticks = yScale.ticks(tickCount);
  const formatTick = yScale.tickFormat(tickCount, (0, _time_label_formatter.getTimeLabelFormat)(startWithOffset.getTime(), endWithOffset.getTime()));
  return /*#__PURE__*/React.createElement("g", null, ticks.map((tick, tickIndex) => {
    var _yScale;
    const y = (_yScale = yScale(tick)) !== null && _yScale !== void 0 ? _yScale : 0;
    return /*#__PURE__*/React.createElement("g", {
      key: `tick${tickIndex}`
    }, /*#__PURE__*/React.createElement(TimeRulerTickLabel, {
      x: 0,
      y: y - 4
    }, formatTick(tick)), /*#__PURE__*/React.createElement(TimeRulerGridLine, {
      x1: 0,
      y1: y,
      x2: width,
      y2: y
    }));
  }));
};
exports.TimeRuler = TimeRuler;
TimeRuler.displayName = 'TimeRuler';
const TimeRulerTickLabel = _common.euiStyled.text`
  font-size: 9px;
  line-height: ${props => props.theme.eui.euiLineHeight};
  fill: ${props => props.theme.eui.euiTextSubduedColor};
  user-select: none;
  pointer-events: none;
`;
const TimeRulerGridLine = _common.euiStyled.line`
  stroke: ${props => props.theme.darkMode ? props.theme.eui.euiColorDarkestShade : props.theme.eui.euiColorDarkShade};
  stroke-opacity: 0.5;
  stroke-width: 1px;
`;