"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuntimeFieldsListItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lib = require("../../lib");
var _delete_field_provider = require("./delete_field_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RuntimeFieldsListItemComponent({
  field,
  areActionButtonsVisible,
  isHighlighted,
  isDimmed,
  editField
}, ref) {
  const {
    source
  } = field;
  const renderActionButtons = () => {
    if (!areActionButtonsVisible) {
      return null;
    }
    const editButtonLabel = _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.editRuntimeFieldButtonLabel', {
      defaultMessage: 'Edit'
    });
    const deleteButtonLabel = _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.removeRuntimeFieldButtonLabel', {
      defaultMessage: 'Remove'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      className: "mappingsEditor__fieldsListItem__actions"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: editButtonLabel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "pencil",
      onClick: editField,
      "data-test-subj": "editFieldButton",
      "aria-label": editButtonLabel
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_delete_field_provider.DeleteRuntimeFieldProvider, null, deleteField => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: deleteButtonLabel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "trash",
      color: "danger",
      onClick: () => deleteField(field),
      "data-test-subj": "removeFieldButton",
      "aria-label": deleteButtonLabel
    })))));
  };
  return /*#__PURE__*/_react.default.createElement("li", {
    className: "mappingsEditor__fieldsListItem",
    "data-test-subj": "runtimeFieldsListItem"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('mappingsEditor__fieldsListItem__field', {
      'mappingsEditor__fieldsListItem__field--enabled': areActionButtonsVisible,
      'mappingsEditor__fieldsListItem__field--highlighted': isHighlighted,
      'mappingsEditor__fieldsListItem__field--dim': isDimmed
    })
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "mappingsEditor__fieldsListItem__wrapper mappingsEditor__fieldsListItem__wrapper--indent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    className: "mappingsEditor__fieldsListItem__content"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "mappingsEditor__fieldsListItem__name",
    "data-test-subj": "fieldName"
  }, source.name), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": "fieldType",
    "data-type-value": source.type
  }, (0, _lib.getTypeLabelFromField)(source))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, renderActionButtons())))));
}
const RuntimeFieldsListItem = exports.RuntimeFieldsListItem = /*#__PURE__*/_react.default.memo(RuntimeFieldsListItemComponent);