"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GuideProgress = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _guide_panel_step = require("../guide_panel_step");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const GuideProgress = ({
  guideConfig,
  styles,
  pluginState,
  isLoading,
  stepsCompleted,
  isGuideReadyToComplete,
  handleStepButtonClick
}) => {
  const {
    flyoutStepsWrapper
  } = styles.flyoutOverrides;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, stepsCompleted > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "data-test-subj": "guideProgress",
    label: isGuideReadyToComplete ? _i18n.i18n.translate('guidedOnboarding.dropdownPanel.completedLabel', {
      defaultMessage: 'Completed'
    }) : _i18n.i18n.translate('guidedOnboarding.dropdownPanel.progressLabel', {
      defaultMessage: 'Progress'
    }),
    value: stepsCompleted,
    valueText: _i18n.i18n.translate('guidedOnboarding.dropdownPanel.progressValueLabel', {
      defaultMessage: '{stepCount} steps',
      values: {
        stepCount: `${stepsCompleted} / ${guideConfig.steps.length}`
      }
    }),
    max: guideConfig.steps.length,
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement("ol", {
    css: flyoutStepsWrapper
  }, guideConfig === null || guideConfig === void 0 ? void 0 : guideConfig.steps.map((step, index) => {
    var _pluginState$activeGu;
    const accordionId = (0, _eui.htmlIdGenerator)(`accordion${index}`)();
    const stepState = pluginState === null || pluginState === void 0 ? void 0 : (_pluginState$activeGu = pluginState.activeGuide) === null || _pluginState$activeGu === void 0 ? void 0 : _pluginState$activeGu.steps[index];
    if (stepState) {
      return /*#__PURE__*/_react.default.createElement("li", {
        key: accordionId
      }, /*#__PURE__*/_react.default.createElement(_guide_panel_step.GuideStep, {
        isLoading: isLoading,
        accordionId: accordionId,
        stepStatus: stepState.status,
        stepConfig: step,
        stepNumber: index + 1,
        handleButtonClick: () => handleStepButtonClick(stepState, step),
        telemetryGuideId: guideConfig.telemetryId
      }));
    }
  })));
};
exports.GuideProgress = GuideProgress;