"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDismissableTour = useDismissableTour;
var _react = _interopRequireDefault(require("react"));
var _constants = require("../constants");
var _use_core = require("./use_core");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDismissableTour(tourKey) {
  var _storage$get;
  const {
    storage,
    uiSettings
  } = (0, _use_core.useStartServices)();
  const defaultValue = uiSettings.get('hideAnnouncements', false) || ((_storage$get = storage.get(_constants.TOUR_STORAGE_KEYS[tourKey])) === null || _storage$get === void 0 ? void 0 : _storage$get.active) === false;
  const [isHidden, setIsHidden] = _react.default.useState(defaultValue);
  const dismiss = _react.default.useCallback(() => {
    setIsHidden(true);
    storage.set(_constants.TOUR_STORAGE_KEYS[tourKey], {
      active: false
    });
  }, [tourKey, storage]);
  return {
    isHidden,
    dismiss
  };
}