"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDownloadedFileName = getDownloadedFileName;
exports.getFileHttpResponseOptions = getFileHttpResponseOptions;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getFileHttpResponseOptions(file) {
  var _file$data$mimeType;
  return {
    fileContentType: (_file$data$mimeType = file.data.mimeType) !== null && _file$data$mimeType !== void 0 ? _file$data$mimeType : 'application/octet-stream',
    headers: {
      'cache-control': 'max-age=31536000, immutable'
    }
  };
}
function getDownloadedFileName(file) {
  // When creating a file we also calculate the extension so the `file.extension`
  // check is not really necessary except for type checking.
  if (file.data.mimeType && file.data.extension) {
    return `${file.data.name}.${file.data.extension}`;
  }
  return file.data.name;
}