"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.operatorsDefinitions = exports.logicalOperators = exports.comparisonFunctions = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("./types");
var _operators = require("./generated/operators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Retrieve the definitions from the operatorFunctionDefinitions. In the operatorFunctionDefinitions there is no distinction between
// other operators and the comparison ones, so we do this here.
const comparisonFunctions = exports.comparisonFunctions = _operators.operatorFunctionDefinitions.filter(({
  name
}) => name === '==' || name === '!=' || name === '<' || name === '>' || name === '<=' || name === '>=');
const logicalOperators = exports.logicalOperators = [{
  name: 'and',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definition.andDoc', {
    defaultMessage: 'and'
  })
}, {
  name: 'or',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definition.orDoc', {
    defaultMessage: 'or'
  })
}].map(({
  name,
  description
}) => ({
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name,
  description,
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_BY, _types.Location.STATS_WHERE],
  signatures: [{
    params: [{
      name: 'left',
      type: 'boolean'
    }, {
      name: 'right',
      type: 'boolean'
    }],
    returnType: 'boolean'
  }]
}));
const otherDefinitions = [{
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: 'not',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definition.notDoc', {
    defaultMessage: 'Not'
  }),
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_BY, _types.Location.STATS_WHERE],
  signatures: [{
    params: [{
      name: 'expression',
      type: 'boolean'
    }],
    returnType: 'boolean'
  }]
}, {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: '=',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definition.assignDoc', {
    defaultMessage: 'Assign (=)'
  }),
  locationsAvailable: [_types.Location.EVAL, _types.Location.STATS, _types.Location.STATS_BY, _types.Location.ROW, _types.Location.WHERE, _types.Location.ENRICH, _types.Location.ENRICH_WITH, _types.Location.DISSECT, _types.Location.COMPLETION, _types.Location.RENAME],
  signatures: [{
    params: [{
      name: 'left',
      type: 'any'
    }, {
      name: 'right',
      type: 'any'
    }],
    returnType: 'unknown'
  }]
}, {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: 'as',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definition.asDoc', {
    defaultMessage: 'Rename as (AS)'
  }),
  locationsAvailable: [_types.Location.RENAME, _types.Location.JOIN],
  signatures: [{
    params: [{
      name: 'oldName',
      type: 'any'
    }, {
      name: 'newName',
      type: 'any'
    }],
    returnType: 'unknown'
  }]
}, {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: 'where',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definition.whereDoc', {
    defaultMessage: 'WHERE operator'
  }),
  locationsAvailable: [_types.Location.STATS],
  signatures: [{
    params: [{
      name: 'left',
      type: 'any'
    }, {
      name: 'right',
      type: 'any'
    }],
    returnType: 'unknown'
  }]
}, {
  // TODO — this shouldn't be a function or an operator...
  name: 'info',
  type: _types.FunctionDefinitionTypes.OPERATOR,
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definition.infoDoc', {
    defaultMessage: 'Show information about the current ES node'
  }),
  locationsAvailable: [_types.Location.SHOW],
  signatures: [{
    params: [],
    returnType: 'unknown' // meaningless
  }]
}];
const isNotNullDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: 'is not null',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.is_not_null', {
    defaultMessage: 'Use `IS NOT NULL` to filter data based on whether the field exists or not.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.SORT, _types.Location.ROW, _types.Location.STATS_WHERE],
  validate: undefined,
  examples: ['FROM employees\n| WHERE is_rehired IS NOT NULL\n| STATS COUNT(emp_no)']
};
const isNullDefinition = {
  type: _types.FunctionDefinitionTypes.OPERATOR,
  name: 'is null',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.is_null', {
    defaultMessage: 'Use `IS NULL` to filter data based on whether the field exists or not.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'left',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'ip',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'left',
      type: 'version',
      optional: false
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.SORT, _types.Location.ROW, _types.Location.STATS_WHERE],
  validate: undefined,
  examples: ['FROM employees\n| WHERE birth_date IS NULL']
};
const operatorsDefinitions = exports.operatorsDefinitions = [..._operators.operatorFunctionDefinitions, isNullDefinition, isNotNullDefinition, ...logicalOperators, ...otherDefinitions];