"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldRulesTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _extraction_rules = require("../../../../../../../../common/types/extraction_rules");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldRulesTable = ({
  editRule,
  fieldRules,
  removeRule
}) => {
  const columns = [{
    field: 'field_name',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.extractionRules.fieldRulesTable.fieldNameLabel', {
      defaultMessage: 'Field name'
    }),
    textOnly: true
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.extractionRulesTable.sourceLabel', {
      defaultMessage: 'Source'
    }),
    render: rule => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, rule.source_type === _extraction_rules.FieldType.HTML ? _i18n.i18n.translate('xpack.enterpriseSearch.crawler.fieldRulesTable.HTMLLabel', {
      defaultMessage: 'HTML: '
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.crawler.fieldRulesTable.UrlLabel', {
      defaultMessage: 'URL: '
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, rule.selector)))
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.fieldRulesTable.contentLabel', {
      defaultMessage: 'Content'
    }),
    render: ({
      content_from: content,
      multiple_objects_handling: multipleObjectsHandling
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, content.value_type === _extraction_rules.ContentFrom.EXTRACTED ? _i18n.i18n.translate('xpack.enterpriseSearch.crawler.fieldRulesTable.extractedLabel', {
      defaultMessage: 'Extracted as: '
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.crawler.fieldRulesTable.fixedLabel', {
      defaultMessage: 'Fixed value: '
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, content.value_type === _extraction_rules.ContentFrom.FIXED ? content.value : multipleObjectsHandling === _extraction_rules.MultipleObjectsHandling.ARRAY ? _i18n.i18n.translate('xpack.enterpriseSearch.crawler.fieldRulesTable.arrayLabel', {
      defaultMessage: 'array'
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.crawler.fieldRulesTable.stringLabel', {
      defaultMessage: 'string'
    }))))
  }, {
    actions: [{
      description: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules.fieldRulesTable.editRule.title', {
        defaultMessage: 'Edit this content field rule'
      }),
      icon: 'pencil',
      isPrimary: false,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules.fieldRulesTable.editRule.caption', {
        defaultMessage: 'Edit this content field rule'
      }),
      onClick: ({
        id
      }) => editRule(id),
      type: 'icon'
    }, {
      color: 'danger',
      description: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules.actions.deleteRule.title', {
        defaultMessage: 'Delete this extraction rule'
      }),
      icon: 'trash',
      isPrimary: false,
      name: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules.actions.deleteRule.caption', {
        defaultMessage: 'Delete extraction rule'
      }),
      onClick: ({
        id
      }) => removeRule(id),
      type: 'icon'
    }],
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules.actions.label', {
      defaultMessage: 'Actions'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: fieldRules,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.extractionRulesTable.title', {
      defaultMessage: 'Crawl rules'
    })
  });
};
exports.FieldRulesTable = FieldRulesTable;