"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MethodConnector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _api = require("../../../../../../common/types/api");
var _doc_links = require("../../../../shared/doc_links");
var _kibana = require("../../../../shared/kibana");
var _licensing = require("../../../../shared/licensing");
var _licensing_callout = require("../../../../shared/licensing_callout/licensing_callout");
var _add_connector_api_logic = require("../../../api/connector/add_connector_api_logic");
var _fetch_cloud_health_api_logic = require("../../../api/stats/fetch_cloud_health_api_logic");
var _error_to_text = require("../utils/error_to_text");
var _add_connector_logic = require("./add_connector_logic");
var _new_connector_template = require("./new_connector_template");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MethodConnector = ({
  serviceType,
  isNative: isNativeProp = true
}) => {
  const {
    apiReset,
    makeRequest
  } = (0, _kea.useActions)(_add_connector_logic.AddConnectorLogic);
  const {
    error,
    status
  } = (0, _kea.useValues)(_add_connector_api_logic.AddConnectorApiLogic);
  const {
    connectorTypes,
    isCloud
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const NATIVE_CONNECTORS = (0, _react.useMemo)(() => connectorTypes.filter(({
    isNative
  }) => isNative), [connectorTypes]);
  const BETA_CONNECTORS = (0, _react.useMemo)(() => connectorTypes.filter(({
    isBeta
  }) => isBeta), [connectorTypes]);
  const isNativeAvailable = Boolean(NATIVE_CONNECTORS.find(connector => connector.serviceType === serviceType)) && isCloud;
  const isBeta = Boolean(BETA_CONNECTORS.find(connector => connector.serviceType === serviceType));
  const isNative = isNativeAvailable && isNativeProp;
  const isGated = isNative && !isCloud && !hasPlatinumLicense;
  const {
    makeRequest: fetchCloudHealth
  } = (0, _kea.useActions)(_fetch_cloud_health_api_logic.FetchCloudHealthApiLogic);
  (0, _react.useEffect)(() => {
    if (isCloud) {
      fetchCloudHealth({});
    }
  }, [isCloud]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, isGated && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_licensing_callout.LicensingCallout, {
    feature: _licensing_callout.LICENSING_FEATURE.NATIVE_CONNECTOR
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_new_connector_template.NewConnectorTemplate, {
    docsUrl: _doc_links.docLinks.connectors,
    disabled: isGated,
    error: (0, _error_to_text.errorToText)(error),
    type: "connector",
    onNameChange: () => {
      apiReset();
    },
    onSubmit: name => makeRequest({
      isNative,
      language: null,
      name,
      serviceType
    }),
    buttonLoading: status === _api.Status.LOADING,
    isBeta: isBeta
  })));
};
exports.MethodConnector = MethodConnector;