"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorDescriptionBadge = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _connector_logo_network_drive_version = _interopRequireDefault(require("../../../../../assets/images/connector_logo_network_drive_version.svg"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const nativePopoverPanels = [{
  description: _i18n.i18n.translate('xpack.enterpriseSearch.connectorDescriptionBadge.native.chooseADataSourceLabel', {
    defaultMessage: "Choose a data source you'd like to sync"
  }),
  icons: [/*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "documents"
  })],
  id: 'native-choose-source'
}, {
  description: _i18n.i18n.translate('xpack.enterpriseSearch.connectorDescriptionBadge.native.configureConnectorLabel', {
    defaultMessage: 'Configure your connector using our Kibana UI'
  }),
  icons: [/*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _connector_logo_network_drive_version.default
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoElastic"
  })],
  id: 'native-configure-connector'
}];
const connectorClientPopoverPanels = [{
  description: _i18n.i18n.translate('xpack.enterpriseSearch.connectorDescriptionBadge.client.chooseADataSourceLabel', {
    defaultMessage: "Choose a data source you'd like to sync"
  }),
  icons: [/*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "documents"
  })],
  id: 'client-choose-source'
}, {
  description: _i18n.i18n.translate('xpack.enterpriseSearch.connectorDescriptionBadge.client.configureConnectorLabel', {
    defaultMessage: 'Deploy connector code on your own infrastructure by running from source, or using Docker'
  }),
  icons: [/*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _connector_logo_network_drive_version.default
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortRight"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "launch"
  })],
  id: 'client-deploy'
}, {
  description: _i18n.i18n.translate('xpack.enterpriseSearch.connectorDescriptionBadge.client.enterDetailsLabel', {
    defaultMessage: 'Enter access and connection details for your data source'
  }),
  icons: [/*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "documents"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortRight"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _connector_logo_network_drive_version.default
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortRight"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoElastic"
  })],
  id: 'client-configure-connector'
}];
const ConnectorDescriptionBadge = ({
  isNative
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const panels = isNative ? nativePopoverPanels : connectorClientPopoverPanels;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      iconSide: "right",
      iconType: "iInCircle",
      onClick: () => setIsPopoverOpen(true),
      onClickAriaLabel: _i18n.i18n.translate('xpack.enterpriseSearch.selectConnector.badgeOnClick.ariaLabel', {
        defaultMessage: 'Click to open connector explanation popover'
      })
    }, isNative ? _i18n.i18n.translate('xpack.enterpriseSearch.selectConnector.nativeBadgeLabel', {
      defaultMessage: 'Elastic managed'
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.selectConnector.connectorClientBadgeLabel', {
      defaultMessage: 'Self-managed'
    })),
    isOpen: isPopoverOpen,
    closePopover: () => {
      setIsPopoverOpen(false);
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, panels.map(panel => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: panel.id
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      alignItems: "center",
      gutterSize: "s",
      style: {
        maxWidth: 240
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s"
    }, panel.icons.map((icon, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: index
    }, icon)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      grow: false,
      textAlign: "center"
    }, /*#__PURE__*/_react.default.createElement("p", null, panel.description)))));
  }))));
};
exports.ConnectorDescriptionBadge = ConnectorDescriptionBadge;